\name{EMURA.Frank}
\alias{EMURA.Frank}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Semi-parametric Inference for Copula Models with Dependently Truncated Data}
\description{A copula-based estimation based on dependent truncation data under 
the Frank copula model (Emura, Wang & Hung 2011; Emura & Murotani 2015).
 The forms of the marginal distributions for X and Y are completely unspecified, but
the parametric form of copula is specified as the Frank copula. 
}
\usage{
EMURA.Frank(x.trunc, z.trunc, d, a = 1/10, plotX = TRUE, plotY = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x.trunc}{vector of variables satisfying x.trunc<=z.trunc}
  \item{z.trunc}{vector of variables satisfying x.trunc<=z.trunc}
  \item{d}{censoring indicator(0=censoring,1=failure) for z.trunc}
  \item{a}{tuning parameter adjusting for small the risk sets (pp.360-361: Emura, Wang & Hung 2011 Sinica)}
  \item{plotX}{if TRUE, plot the distribution function of X}
  \item{plotY}{if TRUE, plot the survival function of Y}
}

\details{The function produces the moment-based estimate for the marginal distributions
 and the estimate of the association parameter under the Frank copula model.
The method can handle right-censoring for Y in which Z=min(Y, C) and I(Y<=C) are observed with
censoring variable C.
}

\value{
\item{alpha }{association parameter}
\item{tau }{Kendall's tau between X and Y}
\item{c }{inclusion probability, defined by c=Pr(X<=Z)}
\item{Fx }{marginal distribution function of X at at (ordered) observed points of X}
\item{Sy }{margianl survival function of Y at (ordered) observed points of Y}
}

\references{
Emura T, Wang W, Hung HN (2011), Semiparametric Inference for Copula Models for Truncated Data, Stat Sinica 21: 349-367.

Emura T, Murotani K (2015), An Algorithm for Estimating Survival Under a Copula-based Dependent Truncation Model, TEST 24 (No.4): 734-751.
}
\author{Takeshi EMURA}

\examples{
###########  AIDS data of Kalbfleisch & Lawless (1989, JASA) #############
inf1=c(23,38,38,36,27,45,23,48,25,42,33,45,33,39,34,48,50,35,26,43,3,53,40,53,
28,34,42,66,19,21,37,33,31,48,32,43,17,64,58,67,49,67,35,12,19,60,53,56,65,53)
inf2=c(36,12,50,45,33,55,37,46,62,57,34,56,57,64,57,42,54,28,36,66,19,45,53,67,
68,54,40,60,54,42,74,71,43,61,68,52,75,46,62,67,48,68,58,55,70,33,56,47,64,15)
inf3=c(41,35,67,35,71,67,36,69,45,76,66,22,74,49,42,15,29,62,65,75,65,69,62,56,
52,82,46,75,27,56,70,49,66,73,76,43,50,41,49,68,39,67,61,82,69,65,56,59,57,57)
inf4=c(46,68,76,64,50,59,80,46,78,26,62,19,22,26,76,27,62,75,76,57,58,59,8,41,
70,57,58,63,37,75,58,39,38,73,72,41,56,50,79,83,76,29,17,69,86,29,65,75,74,42)
inf5=c(65,61,84,41,83,58,45,83,80,84,59,85,59,65,47,64,73,81,79,36,67,87,85,29,
72,77,72,67,53,54,17,61,65,48,57,29,36,30,45,40,75,43,76,66,86,57,75,71,51)
inf6=c(60,41,53,48,36,72,60,36,48,55,58,60,89,37,82,41,68,71,63,49,37,60,78,52,
60,85,68,37,39,22,12,63,80,45,47,85,29,60,84,70,61,69,77,63)
x1=c(27,14,15,18,28,10,34,17,34,17,29,17,29,23,29,15,13,29,38,21,61,12,25,12,38,
32,24,0,48,46,30,34,37,21,37,26,53,6,13,4,22,4,37,60,53,13,20,17,8,20)
x2=c(38,62,24,29,41,19,37,28,13,18,41,19,18,11,18,33,21,48,40,10,58,32,24,11,10,
25,39,19,25,37,5,8,37,20,13,29,6,35,19,14,33,13,23,27,12,49,26,35,18,68)
x3=c(42,48,16,48,12,16,47,14,38,8,18,62,10,35,42,69,55,22,20,10,20,16,23,30,34,4,
40,11,59,30,16,37,20,13,10,43,36,46,38,19,48,20,26,5,18,23,32,29,31,31)
x4=c(42,20,12,24,38,29,8,43,11,63,27,70,67,63,13,62,27,15,14,33,32,32,83,50,21,
34,33,29,55,17,34,53,54,19,20,52,37,43,14,10,17,64,76,25,8,65,29,19,20,52)
x5=c(29,33,10,53,11,36,49,12,15,11,36,10,36,31,49,32,23,15,17,60,29,9,11,67,24,
19,24,29,43,43,80,36,32,49,40,68,61,68,53,58,23,55,22,32,12,41,23,27,47)
x6=c(38,57,46,51,63,27,39,63,51,44,41,39,10,63,18,59,32,29,37,51,63,40,22,48,40,
15,33,64,62,79,89,38,21,56,54,16,72,41,17,31,40,32,24,38)

t=c(inf1,inf2,inf3,inf4,inf5,inf6) #### the month of infection with 1=January 1978 ####
x=c(x1,x2,x3,x4,x5,x6) #### the duration of the incubation period (month) ####
y=102-t #### 102 is the study period (month) ####

######### Breaking ties by adding small noise to the data ########## 
set.seed(1)
x=x+runif(293,min=-0.4,max=0.4)
y=y+runif(293,min=-0.4,max=0.4)
x[x<=0]=runif(1,0,0.4)

x.trunc=x
z.trunc=y
d=rep(1,length(x.trunc)) ### all data is not censored ###

EMURA.Frank(x.trunc,z.trunc,d)[c(1,2,3)]
######### The same numerical results as Table 3 of Emura et al. (2011) ###########
}

\keyword{ Copula }
\keyword{ Semiparametric method }% __ONLY ONE__ keyword per line
