% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_table.R
\name{freq_table}
\alias{freq_table}
\alias{format.freq_table}
\alias{pre_print.freq_table}
\title{Frequency table}
\usage{
freq_table(
  data,
  x,
  cols = "n",
  weights = NULL,
  na.rm = FALSE,
  total = FALSE,
  max = NA
)

\method{format}{freq_table}(x, ..., n = NULL, width = NULL, n_extra = NULL)

\method{pre_print}{freq_table}(x)
}
\arguments{
\item{data}{a tibble}

\item{x}{a factor or a discrete numerical variable}

\item{cols}{a string containing \code{n} for counts, \code{f} for relative
frequencies and \code{p} for percentages : cumulative series are
obtained using the same letters in upper caps}

\item{weights}{a series that contain the weights than enables the
sample to mimic the population}

\item{na.rm}{with the default value \code{TRUE}, missing values of \code{x}
are removed l'échantillon}

\item{total}{if \code{TRUE} (the default value), a total is added to the
table}

\item{max}{if the series is a discrete numerical value, this
argument indicates that all the values greater than \code{max}
should be merged in the same modality}

\item{...}{other arguments (for \code{format})}

\item{n}{the number of rows to print (passed to \code{format})}

\item{width}{the width of the table to be printed (passed to
\code{format})}

\item{n_extra}{the number of extra columns described (passed to
\code{format})}
}
\value{
an object of class \code{freq_table} which inherits from
\code{tbl_df}
}
\description{
A frequency table is suitable for a factor or for a discrete
numerical variable. It returns the modalities/values and the
associated frequencies
}
\examples{

freq_table(employment, activity, "n")
freq_table(employment, activity, "nN")
freq_table(employment, activity, "fF", weights = weights)
freq_table(rgp, children, "npNP")
freq_table(rgp, children, "npNP", max = 5)
}
\author{
Yves Croissant
}
