% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gain_function.R
\name{gain,deseats-method}
\alias{gain,deseats-method}
\title{Obtain gain function values for DeSeaTS Trend and Detrend Filters}
\usage{
\S4method{gain}{deseats}(object, lambda = seq(0, 0.5, 1e-04), ...)
}
\arguments{
\item{object}{an object of class \code{"deseats"}.}

\item{lambda}{a numeric vector with the frequencies at which to get 
the gain function values.}

\item{...}{no current purpose for this ellipsis.}
}
\value{
A list is returned. Each element represents gain function values 
at the specified frequencies \code{lambda} for the filter defined 
through the element name.
\describe{
\item{\code{gain_trend}}{gain function values for the trend filter.}
\item{\code{gain_detrend}}{gain function values for the detrending filter.}
\item{\code{gain_season}}{gain function values for the seasonality filter.}
\item{\code{gain_deseason}}{gain function values for the seasonal 
adjustment filter.}
\item{\code{gain_comb}}{gain function values for the trend + seasonality 
filter.}
\item{\code{gain_decomb}}{gain function values for the detrending + seasonal 
adjustment filter.}
}
}
\description{
Obtain gain function values for DeSeaTS Trend and Detrend Filters
}
\details{
The various filters obtained via \code{\link{deseats}} (represented by 
the returned weighting systems) have a representation in the frequency 
domain. Using this method, those gain function values can be easily 
obtained.
}
\examples{
\donttest{
xt <- log(EXPENDITURES)
est <- deseats(xt)

lambda <- seq(0, 0.5, 0.01)
gain_values <- gain(est, lambda = lambda)
m <- length(gain_values$gain_trend[, 1])
k <- (m - 1) / 2
colF <- colorRampPalette(c("deepskyblue4", "deepskyblue"))
cols <- colF(m)

matplot(lambda, t(gain_values$gain_decomb[1:(k + 1), ]), 
 type = paste0(rep("l", k + 1), collapse = ""),
 col = cols, lty = rep(1, k + 1))
title("Gain functions of the combined detrend and deseasonalization filters")

matplot(lambda, t(gain_values$gain_trend[1:(k + 1), ]), 
 type = paste0(rep("l", k + 1), collapse = ""),
 col = cols, lty = rep(1, k + 1))
title("Gain functions of the trend filters")

matplot(lambda, t(gain_values$gain_deseason[1:(k + 1), ]), 
 type = paste0(rep("l", k + 1), collapse = ""),
 col = cols, lty = rep(1, k + 1))
title("Gain functions of the seasonal adjustment filters")
} 

}
\author{
\itemize{
\item Dominik Schulz (Research Assistant) (Department of Economics, Paderborn
University), \cr
Author and Package Creator
}
}
