% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_nls.R
\name{devRatePrint}
\alias{devRatePrint}
\title{Report model output from the NLS fit}
\usage{
devRatePrint(myNLS, doPlots = FALSE)
}
\arguments{
\item{myNLS}{An object of class NLS}

\item{doPlots}{A boolean to get the residual plot (default = FALSE)}
}
\value{
A list of six objects (summary of the NLS fit; confidence intervals
  for the model parameters; test of normality; test of independence; AIC, BIC)
}
\description{
Provide a custom output of the NLS fit.
}
\examples{
myT <- 5:15
myDev <- -0.05 + rnorm(n = length(myT), mean = myT, sd = 1) * 0.01
myNLS <- devRateModel(
  eq = campbell_74,
  temp = myT,
  devRate = myDev,
  startValues = list(aa = 0, bb = 0))
devRatePrint(myNLS)

rawDevEggs <- matrix(c(10, 0.031, 10, 0.039, 15, 0.047, 15, 0.059, 15.5, 0.066,
   13, 0.072, 16, 0.083, 16, 0.100, 17, 0.100, 20, 0.100, 20, 0.143, 25, 0.171,
   25, 0.200, 30, 0.200, 30, 0.180, 35, 0.001), ncol = 2, byrow = TRUE)
mEggs <- devRateModel(
  eq = taylor_81,
  temp = rawDevEggs[,1],
  devRate = rawDevEggs[,2],
  startValues = list(Rm = 0.05, Tm = 30, To = 5))
devRatePrint(myNLS = mEggs)
}
