% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{profile_plot}
\alias{profile_plot}
\title{Profile plot}
\usage{
profile_plot(dataSrc, item_property, covariate, predicate = NULL,
  model = "IM", x = NULL, ...)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: 
person_id, item_id, item_score and the item_property and the covariate of interest.}

\item{item_property}{The name of the item property defining the domains. 
The item property should have exactly two distinct values in your data}

\item{covariate}{name of the person property/covariate used to create the groups. 
There will be one line for each distinct value.}

\item{predicate}{An optional expression to filter data, if NULL all data is used}

\item{model}{"IM" (default) or "RM" where "IM" is the interaction model and 
"RM" the Rasch model. The interaction model is the default as it fits 
the data better or at least as good as the Rasch model.}

\item{x}{Which value of the item_property to draw on the x axis, if NULL, one is chosen automatically}

\item{...}{further arguments to plot, many have useful defaults}
}
\value{
Nothing interesting
}
\description{
Profile plot
}
\details{
Profile plots can be used to investigate whether two (or more) groups of respondents 
attain the same test score in the same way. The user must provide a  
(meaningful) classification of the items in two non-overlapping subsets such that 
the test score is the sum of the scores on the subsets. 
The plot shows the probabilities to obtain 
any combinations of subset scores with thin gray lines indicating the combinations 
that give the same test score. The thick lines connect the most likely 
combination for each test score in each group.
When applied to educational test data, the plots can be used to detect differences in the 
relative difficulty of (sets of) items for respondents that belong to different 
groups and are matched on the test score. This provides a content-driven way to 
investigate differential item functioning.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db", covariates=list(gender="<unknown>"))
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)
profile_plot(db, item_property='mode', covariate='gender')

close_project(db)
}


}
