% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dif.R
\name{DIF}
\alias{DIF}
\title{Exploratory test for Differential Item Functioning}
\usage{
DIF(dataSrc, person_property, predicate = NULL)
}
\arguments{
\item{dataSrc}{a connection to a dexter database or a data.frame with columns: person_id, item_id, item_score}

\item{person_property}{Defines groups of persons to calculate DIF}

\item{predicate}{An optional expression to subset data, if NULL all data is used}
}
\value{
An object of class \code{DIF_stats} holding statistics for
overall-DIF and a matrix of statistics for DIF in the relative position of
item-category parameters in the beta-parameterization where they represent 
locations on the ability scale where adjacent categories are equally likely. 
If there is DIF, the function `plot` can be used to produce an image of the pairwise DIF statistics.
}
\description{
Exploratory test for Differential Item Functioning
}
\details{
Tests for equality of relative item/category difficulties across groups.
Supplements the confirmatory approach of the profile plot.
}
\examples{

\dontshow{ RcppArmadillo::armadillo_throttle_cores(1)}

db = start_new_project(verbAggrRules, ":memory:", person_properties=list(gender='unknown'))
add_booklet(db, verbAggrData, "agg")
dd = DIF(db,person_property="gender")
print(dd)
plot(dd)
str(dd)

close_project(db)

\dontshow{ RcppArmadillo::armadillo_reset_cores()}

}
\references{
Bechger, T. M. and Maris, G (2015); A Statistical Test for Differential Item Pair Functioning. 
Psychometrika. Vol. 80, no. 2, 317-340.
}
\seealso{
A plot of the result is produced by the function \code{\link{plot.DIF_stats}}
}
