\name{ZKO}
\alias{ZKO}

\title{
Meta-analysis approach based on Zohar et al, 2011. 
}

\description{
This function utilizes the meta-analysis approach proposed by Zohar et al, 2011. It utilizes the power model \deqn{\Psi(x, \alpha) = (\alpha(x))^{a}} in order to estimate \eqn{a} by running simulated CRMs using \deqn{R_C(x) = \sum_{i=1}^{r} \frac{N_{i.}}{N_{..}} \bar{R_i}(x).} Then the estimated dose-toxicity curve is used to estimate the maximum tolerated dose (MTD). 
}

\usage{
ZKO(dataTox, doses, target = 0.3, dr, nbSimu)
}

\arguments{
  \item{dataTox}{
a data frame containing information for each patient at each simulation and trial. The data frame must have the following structure with the column's names be set as: 1) "doses", representing the drug's dose levels, 2) "proba", representing the true probabilities of toxicity, 3) "nbPatients", representing the number of patients at each dose level and 4) "nbTox", representing the number of DLTs obtained at each dose level. The data frames with different structure will not be accepted in the function.
}
  \item{doses}{
a vector containing the drug's dose levels.
}
  \item{target}{
the target of the probability of toxicity; defaults to 0.3.
}
  \item{dr}{
the initial guess of dose-toxicity relationship (usually is selected based on information from experts).
}
  \item{nbSimu}{
the number of simulated CRM studies.  
}
}

\value{
    An object of class "ZKO" is returned, consisting the estimated probability of toxicity. Objects generated by ZKO function contain at least the following components:

    \item{dataTox}{A data frame containing information for each patient at each simulation and trial. The data frame must be have the following structure with the column's names be set as: 1) "doses", 2) "proba", 3) "nbPatients" and 4) "nbTox". Note that, any data frames with different structure will not be accepted in the function.}
	\item{target}{The target of probability of toxicity.}
	\item{doses}{A vector with the doses panel.}
	\item{ti}{A vector including the total number of toxicities at each dose level.}
	\item{ni}{A vector consisting the total number of patients at each dose level.}
	\item{realite}{A vector with the observed toxicity probabilities at each dose level.}
	\item{relfreq}{A vector with the mean relative frequencies of allocation at each dose level.}
	\item{estimAlpha}{The estimated value for variable alpha.}
	\item{estimProb}{The estimated probability of toxicity.}
}

\author{
Artemis Toumazi <artemis.toumazi@gmail.com>, Sarah Zohar <sarah.zohar@inserm.fr>, Anand N. Vidyashankar <avidyash@gmu.edu>, Jie Xu <jxu13@gmu.edu> and Moreno Ursino <moreno.ursino@inserm.fr>
}

\references{
Zohar, S., Katsahian, S. and O'Quigley, J. (2011), An approach to meta analysis of dose finding studies. Statist. Med., <doi:10.1002/sim.4121>.
}

\seealso{
\code{\link{VarWT}}
}

\examples{
  \dontrun{
  
  	###############################################
  	#### A simple example using a simple data #####
  	###############################################
  
  	vanGroeningen <- rbind(c(25,0/6, 6), c(35, 0/5,5), c(40, 4/11, 11), c(45, 3/5, 5))
  	Hoff <- rbind(c(30, 3/9, 9), c(35, 2/3, 3), c(40, 2/3, 3))
  	Zhu <- rbind(c(30, 0/12, 12), c(35, 2/3, 3))
  	dataTox <- rbind(vanGroeningen, Hoff, Zhu)
  	dataTox <- data.frame(dataTox)
  	colnames(dataTox) <- c("doses", "proba", "nbPatients")
  	nbTox <- dataTox$proba*dataTox$nbPatients
  	dataTox <- data.frame(dataTox, nbTox)
  	doses <- c(25, 30, 35, 40, 45)
  	nbSimu <- 10
  	zko <- ZKO(dataTox, doses, target = 0.3, dr = c(0.05, 0.15, 0.2, 0.3, 0.35), nbSimu)
    
  	###########################################################################
  	################ A second example using the data "Toxdata" ################
  	################### included in the "dfmeta" R package ####################
  	###########################################################################
  
  	data(Toxdata)
  	pos <- which(Toxdata$simulation == 0)
  	dataTox2 <- Toxdata[pos, ]
  	dataTox2 <- dataTox2[, c(2,6,4,5)]
  
  	### Remember that the structure of the database must be in the following structure ###
  
  	colnames(dataTox2) <- c("doses", "proba", "nbPatients", "nbTox")
  	doses <- 0:5
  	nbSimu <- 10
  	zko2 <- ZKO(dataTox2, doses, target = 0.3, dr = c(0.05, 0.15, 0.2, 0.3, 0.35, 0.45),
  	nbSimu)
  }
}
