% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fatdiag.R
\name{fatdiag}
\alias{fatdiag}
\alias{fatdiag<-}
\title{Fat Matrix Diagonals}
\usage{
fatdiag(x = 1, steps = NULL, size = NULL, nrow = NULL, ncol = NULL)

fatdiag(x, steps = NULL, size = NULL, on_diagonal = TRUE) <- value
}
\arguments{
\item{x}{a matrix where the dimensions are integer multiples of size or integer dividors of steps}

\item{steps}{the required number of steps (block matrices) across the diagonal}

\item{size}{the width or height of the matrix being dropped over the diagonal of matrix x}

\item{nrow}{the number of rows}

\item{ncol}{the number of columns}

\item{on_diagonal}{should the operation be apply to the elements on the fat diagonal.}

\item{value}{replacement value}
}
\description{
Fat Matrix Diagonals

fatdiag set
}
\details{
Either steps or size is expected to be provided.
}
\section{Functions}{
\itemize{
\item \code{fatdiag<-}: the set version of fatdiag
}}

\examples{
fatdiag(12, steps=3)

( m <- matrix(111, nrow=6, ncol=9) )
fatdiag(m, steps=3) <- 5

fatdiag(m, steps=3)

fatdiag(12, size=4)

fatdiag(12, size=c(3,4) )
}
