% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example.R
\name{get_example}
\alias{get_example}
\title{Get an example phone number}
\usage{
get_example(region, type = NULL, valid = TRUE)
}
\arguments{
\item{region}{A character vector of \link[=dialr-region]{ISO country codes}.}

\item{type}{A character vector of \link[=dialr-type]{phone number types}. If
\code{NULL} (default), returns an example "FIXED_LINE" number.}

\item{valid}{A logical vector. For each \code{FALSE} entry, \code{get_example} returns
an example invalid number, and \code{type} is ignored.}
}
\value{
A \link{phone} vector.
}
\description{
Produces example phone numbers for the given \code{\link[=dialr-region]{region}},
\code{\link[=dialr-type]{type}} and \code{valid} combinations. Input vectors are recycled as
necessary if a vector of length 1 is provided.
}
\section{libphonenumber reference}{


\code{get_example()}: \code{PhoneNumberUtil.getExampleNumberForType()};
\code{PhoneNumberUtil.getExampleNumber()} if \code{type} is \code{NULL} or \code{NA};
\code{PhoneNumberUtil.getInvalidExampleNumber()} if \code{valid} is \code{FALSE}.
}

\examples{
# Get a basic example number
get_example("AU")

# Get an example mobile number
get_example("AU", type = "MOBILE")

# Get an example invalid number
get_example("AU", valid = FALSE)

# Get a combination of the previous examples
get_example(c("AU", "AU",     "AU" ),
            c(NA,   "MOBILE", NA   ),
            c(TRUE, TRUE,     FALSE))
}
