% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_adjust_reg_free.R
\name{adjust_deg_free}
\alias{adjust_deg_free}
\title{Parameters to adjust effective degrees of freedom}
\usage{
adjust_deg_free(range = c(0.25, 4), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
This parameter can be used to moderate smoothness of spline or other terms
used in generalized additive models.
}
\details{
Used in \code{parsnip::gen_additive_mod()}.
}
\examples{
adjust_deg_free()
}
