% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_over_ratio.R
\name{over_ratio}
\alias{over_ratio}
\alias{under_ratio}
\title{Parameters for class-imbalance sampling}
\usage{
over_ratio(range = c(0.8, 1.2), trans = NULL)

under_ratio(range = c(0.8, 1.2), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::transform_log10()} or \code{scales::transform_reciprocal()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
For up- and down-sampling methods, these parameters control how much data are
added or removed from the training set. Used in \code{themis::step_rose()},
\code{themis::step_smotenc()}, \code{themis::step_bsmote()}, \code{themis::step_upsample()},
\code{themis::step_downsample()}, and \code{themis::step_nearmiss()}.
}
\examples{
under_ratio()
over_ratio()
}
