% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_validity.R
\name{external_validity}
\alias{external_validity}
\alias{ev_nmi}
\alias{ev_confmat}
\title{External validity indices}
\usage{
ev_nmi(pred.lab, ref.lab, method = "emp")

ev_confmat(pred.lab, ref.lab)
}
\arguments{
\item{pred.lab}{predicted labels generated by classifier}

\item{ref.lab}{reference labels for the observations}

\item{method}{method of computing the entropy. Can be any one of "emp", "mm",
"shrink", or "sg".}
}
\value{
\code{ev_nmi} returns the normalized mutual information.

\code{ev_confmat} returns a vector of the following metrics: overall
accuracy, Cohen's kappa, no information rate, accuracy p-value. Statistics
are difficult to compare when there are multiclass comparisons. We hence
also report averaged statistics for: sensitivity, specificity, PPV, NPV,
prevalence, detection rate, detection prevalence, accuracy, and balanced
accuracy.
}
\description{
\strong{E}xternal \strong{v}alidity indices compare a predicted clustering
result with a reference class or gold standard.
}
\details{
\code{ev_nmi} calculates the normalized mutual information

\code{ev_confmat} calculates a variety of statistics associated with
confusion matrices.
}
\note{
\code{ev_nmi} is adapted from \code{\link[infotheo:mutinformation]{infotheo::mutinformation()}}
}
\examples{
set.seed(1)
E <- matrix(rep(sample(1:4, 1000, replace = TRUE)), nrow = 100, byrow =
              FALSE)
x <- sample(1:4, 100, replace = TRUE)
y <- sample(1:4, 100, replace = TRUE)
ev_nmi(x, y)
ev_confmat(x, y)
}
\references{
Strehl A, Ghosh J. Cluster ensembles: a knowledge reuse framework
for combining multiple partitions. J. Mach. Learn. Res. 2002;3:583-617.
}
\author{
Johnson Liu, Derek Chiu
}
