% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_tdv_gurobi_k_2.R
\name{optim_tdv_gurobi_k_2}
\alias{optim_tdv_gurobi_k_2}
\title{Total Differential Value optimization using Gurobi}
\usage{
optim_tdv_gurobi_k_2(m_bin, formulation = "t-dependent", time_limit = 5)
}
\arguments{
\item{m_bin}{A matrix. A phytosociological table of 0s (absences) and 1s
(presences), where rows correspond to taxa and columns correspond to
relevés.}

\item{formulation}{A character selecting which formulation to use. Possible
values are "t-dependent" (the default) or "t-independent". See Details.}

\item{time_limit}{A numeric ("double") with the time limit (in seconds) to
be passed as a parameter to Gurobi, Defaults to 5 seconds, but see Details.}
}
\value{
For \code{formulation = "t-dependent"}, a list with the following
components:

\describe{
\item{status.runs}{A character vector with Gurobi output status for all
the runs.}
\item{objval}{A numeric with the maximum TDV found by Gurobi.}
\item{par}{A vector with the 2-partition corresponding to the the
maximum TDV found by Gurobi.}
}

For \code{formulation = "t-independent"}, a list with the following components:

\describe{
\item{status}{A character with Gurobi output status.}
\item{objval}{A numeric with the maximum TDV found by Gurobi.}
\item{par}{A vector with the 2-partition corresponding to the the
maximum TDV found by Gurobi.}
}
}
\description{
Given a phytosociological matrix, this function finds a partition in two
groups of the matrix columns, which maximizes the Total Differential Value
(TDV).
}
\details{
Given a phytosociological table \code{m_bin} (rows corresponding to taxa
and columns corresponding to relevés) this function finds a 2-partition (a
partition in two groups) that maximizes TDV, using the Gurobi optimizer.

\href{https://www.gurobi.com/}{Gurobi} is a commercial software for which a free
academic license can be obtained if you are affiliated with a recognized
educational institution. Package 'prioritizr' contains a comprehensive
vignette (\href{https://prioritizr.net/articles/gurobi_installation_guide.html}{Gurobi Installation Guide}),
which can guide you trough the process of obtaining a license, installing
the \href{https://www.gurobi.com/products/gurobi-optimizer/}{Gurobi optimizer},
activating the license and eventually installing the R package 'gurobi'.

\code{\link[=optim_tdv_gurobi_k_2]{optim_tdv_gurobi_k_2()}} returns, when the optimization is successful, a
2-partition which is a global maximum of TDV for any 2-partitions of the
columns on \code{m_bin}.

See \code{\link[=tdv]{tdv()}} for an explanation on the Total Differential Value of a
phytosociological table.

The function implements two different mixed-integer linear programming
formulations of the problem. The formulations differ as one is independent
of the size of the obtained groups (t-independent), while the other
formulation fixes the size of the obtained groups (t-dependent). The
t-dependent formulation is implemented to run Gurobi as many times as
necessary to cover all possible group sizes; this approach can result in
faster total computation time.

For medium-sized matrices the computation time might become already
prohibitive, thus the use of a time limit (\code{time_limit}) is advisable.
}
\examples{
# Getting the Taxus baccata forests data set
data(taxus_bin)

# Obtaining the 2-partition that maximizes TDV using the Gurobi solver, by
# mixed-integer linear programming
\dontrun{
# Requires the suggested package 'gurobi'
optim_tdv_gurobi_k_2(taxus_bin)
}

}
\author{
Jorge Orestes Cerdeira and Tiago Monteiro-Henriques.
E-mail: \email{tmh.dev@icloud.com}.
}
