% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{distErrorPlot}
\alias{distErrorPlot}
\title{Generate box plots or violin plots to show how the errors are distributed}
\usage{
distErrorPlot(
  object,
  error,
  colors,
  x.by = "pBin",
  facet.by = NULL,
  color.by = "nCellTypes",
  filter.sc = TRUE,
  error.label = FALSE,
  pos.x.label = 4.6,
  pos.y.label = NULL,
  size.point = 0.1,
  alpha.point = 1,
  type = "violinplot",
  ylimit = NULL,
  nrow = NULL,
  ncol = NULL,
  title = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with
\code{trained.model} slot containing metrics in the
\code{test.deconv.metrics} slot of a
\code{\linkS4class{DigitalDLSorterDNN}} object.}

\item{error}{The error to be represented. Available errors are absolute error
(\code{'AbsErr'}), proportional absolute error (\code{'ppAbsErr'}), squared
error (\code{'SqrErr'}) and proportional squared error (\code{'ppSqrErr'}).}

\item{colors}{Vector of colors to be used. Only vectors with a number of
colors equal to or greater than the levels of \code{color.by} will be
accepted. By default, a custom color list is used.}

\item{x.by}{Variable used for the X-axis. When \code{facet.by} is not
\code{NULL}, the best choice is \code{pBin} (probability bins). The options
are \code{nCellTypes} (number of different cell types), \code{CellType}
(cell type) and \code{pBin}.}

\item{facet.by}{Variable used to display data in different panels. If
\code{NULL}, the plot is not split into different panels. Options are
\code{nCellTypes} (number of different cell types) and \code{CellType}
(cell type).}

\item{color.by}{Variable used to color the data. Options are
\code{nCellTypes} and \code{CellType}.}

\item{filter.sc}{Boolean indicating whether single-cell profiles are filtered
out and only errors associated with pseudo-bulk samples are displayed
(\code{TRUE} by default).}

\item{error.label}{Boolean indicating whether to display the average error as
a plot annotation (\code{FALSE} by default).}

\item{pos.x.label}{X-axis position of error annotations.}

\item{pos.y.label}{Y-axis position of error annotations.}

\item{size.point}{Size of points (0.1 by default).}

\item{alpha.point}{Alpha of points (0.1 by default).}

\item{type}{Type of plot: \code{'boxplot'} or \code{'violinplot'}. The latter
by default.}

\item{ylimit}{Upper limit in Y-axis if it is required (\code{NULL} by
default).}

\item{nrow}{Number of rows if \code{facet.by} is not \code{NULL}.}

\item{ncol}{Number of columns if \code{facet.by} is not \code{NULL}.}

\item{title}{Title of the plot.}

\item{theme}{\pkg{ggplot2} theme.}

\item{...}{Additional arguments for the \link[ggplot2]{facet_wrap} function
from \pkg{ggplot2} if \code{facet.by} is not \code{NULL}.}
}
\value{
A ggplot object with the representation of the desired errors.
}
\description{
Generate violin plots or box plots to show how the errors are distributed by
proportion bins of 0.1. Errors can be displayed all mixed or split by cell
type (\code{CellType}) or number of cell types present in the samples
(\code{nCellTypes}). See the \code{facet.by} argument and examples for more
details.
}
\examples{
\dontrun{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
DDLS <- createDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE, 
  sc.log.FC = FALSE
)
probMatrixValid <- data.frame(
  Cell_Type = paste0("CellType", seq(6)),
  from = c(1, 1, 1, 15, 15, 30),
  to = c(15, 15, 30, 50, 50, 70)
)
DDLS <- generateBulkCellMatrix(
  object = DDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  prob.design = probMatrixValid,
  num.bulk.samples = 50,
  verbose = TRUE
)
# training of DDLS model
tensorflow::tf$compat$v1$disable_eager_execution()
DDLS <- trainDDLSModel(
  object = DDLS,
  on.the.fly = TRUE,
  batch.size = 15,
  num.epochs = 5
)
# evaluation using test data
DDLS <- calculateEvalMetrics(
  object = DDLS
)
# representation, for more examples, see the vignettes
distErrorPlot(
  object = DDLS,
  error = "AbsErr",
  facet.by = "CellType",
  color.by = "nCellTypes",
  error.label = TRUE
)
distErrorPlot(
  object = DDLS,
  error = "AbsErr",
  x.by = "CellType",
  facet.by = NULL,
  filter.sc = FALSE,
  color.by = "CellType",
  error.label = TRUE
)
}

}
\seealso{
\code{\link{calculateEvalMetrics}} \code{\link{corrExpPredPlot}}
\code{\link{blandAltmanLehPlot}} \code{\link{barErrorPlot}}
}
