% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-compoundInput2.R
\name{updateCompoundInput2}
\alias{updateCompoundInput2}
\title{Update compound inputs}
\usage{
updateCompoundInput2(session, inputId, value = NULL, ncomp = NULL,
  initialization = NULL, ...)
}
\arguments{
\item{session}{shiny session or session proxy}

\item{inputId}{character see \code{compoundInput2}}

\item{value}{list of lists, see \code{compoundInput2} or examples}

\item{ncomp}{integer, non-negative number of groups to update, \code{NULL} to
remain unchanged}

\item{initialization, ...}{named list of other updates}
}
\value{
none
}
\description{
Update compound inputs
}
\examples{

\dontrun{
library(shiny); library(dipsaus)

## UI side
compoundInput2(
  'input_id', 'Group',
    div(
    textInput('text', 'Text Label'),
    sliderInput('sli', 'Slider Selector', value = 0, min = 1, max = 1)
  ),
  label_color = 1:10,
  value = list(
    list(text = '1'),  # Set text first group to be "1"
    '',                # no settings for second group
    list(sli = 0.2)    # sli = 0.2 for the third group
  ))

## server side:
updateCompoundInput2(session, 'inputid',
                     # Change the first 3 groups
                     value = lapply(1:3, function(ii){
                       list(sli = runif(1))
                     }),
                     # Change text label for all groups
                     initialization = list(
                       text = list(label = as.character(Sys.time()))
                     ))
}

}
\seealso{
\code{\link[dipsaus]{compoundInput2}} for how to define components.
}
