% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_sample.R
\name{in_sample}
\alias{in_sample}
\title{Producing the in sample predictions of a prais-lm regression}
\usage{
in_sample(object, type = "changes")
}
\arguments{
\item{object}{an object of class \code{praislm} or \code{twoStepsBenchmark}}

\item{type}{"changes" or "levels". The results are either returned
in changes or in levels.}
}
\value{
a named matrix time-serie of two columns, one for the
response and the other for the predicted value.
A \code{insample} class is added to the object. Then, the functions
\code{plot} and \code{autoplot} (the latter requires to load \pkg{ggplot2})
can be used to produce graphics.
}
\description{
The function \code{in_sample} returns in-sample predictions from
a \link{praislm} or a \link{twoStepsBenchmark} object.
}
\details{
The predicted values are different from the fitted values :
\itemize{
\item they are eventually reintegrated
\item the autocorrelated part of the residuals is added
Besides, changes are relative to the latest response value,
not the latest predicted value.
}
}
\examples{
benchmark <- twoStepsBenchmark(turnover,construction,include.rho = TRUE)
in_sample(benchmark)
}
