% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2023-04-24_DisclosuR.R
\name{newswire_segmenter}
\alias{newswire_segmenter}
\title{Newswire segmenter}
\usage{
newswire_segmenter(
  file,
  sentiment = FALSE,
  emotion = FALSE,
  regulatory_focus = FALSE,
  laughter = FALSE,
  narcissism = FALSE,
  text_clustering = FALSE
)
}
\arguments{
\item{file}{The name of the PDF file which the data are to be read
from. If it does not contain an absolute path, the file name is
relative to the current working directory, getwd().}

\item{sentiment}{Performs dictionary-based sentiment analysis
based on the \code{\link[SentimentAnalysis]{analyzeSentiment}}
function (default: FALSE)}

\item{emotion}{Performs dictionary-based emotion analysis based on the
\code{\link[syuzhet]{get_nrc_sentiment}} function (default: FALSE)}

\item{regulatory_focus}{Calculates the number of words indicative for
promotion and prevention focus based on the
dictionary developed by \href{https://psycnet.apa.org/record/2015-41859-013}{Gamache et al., 2015}
(default: FALSE)}

\item{laughter}{Counts the number of times laughter was indicated in a quote. (default: FALSE)}

\item{narcissism}{Counts the number of pronoun usage and calculates the ratio of first-person singular to
first-person plural pronouns. This measure is derived from \href{https://psycnet.apa.org/record/2015-06474-002}{Zhu & Chen, (2015}
(default: FALSE)}

\item{text_clustering}{Applies a document categorization using a dictionary developed based on the framework developed by \href{https://escholarship.org/uc/item/026179rh}{Graffin et al., 2016}. (default: FALSE)}
}
\value{
An R data frame with each row representing one 'newswire' article. The columns indicate the title, text,
'newswire', date, and weekday.
}
\description{
Takes a PDF document containing a 'newswire' document obtained from 'NexisUni' and transforms it into
an R data frame consisting of one row
}
\examples{
newswire_df <- newswire_segmenter(
file = system.file("inst",
"examples",
"newswire", "newswire_example_01.pdf",
package = "disclosuR"));
newswire_df_sentiment <- newswire_segmenter(
file = system.file("inst",
"examples",
"newswire", "newswire_example_01.pdf",
sentiment = TRUE,
package = "disclosuR"));
}
