% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testParameterSetCollection}
\alias{testParameterSetCollection}
\alias{checkParameterSetCollection}
\alias{assertParameterSetCollection}
\title{assert/check/test/ParameterSetCollection}
\usage{
testParameterSetCollection(
  object,
  errormsg = paste(object, "is not an R6 ParameterSetCollection object")
)

checkParameterSetCollection(
  object,
  errormsg = paste(object, "is not an R6 ParameterSetCollection object")
)

assertParameterSetCollection(
  object,
  errormsg = paste(object, "is not an R6 ParameterSetCollection object")
)
}
\arguments{
\item{object}{object to test}

\item{errormsg}{custom error message to return if assert/check fails}
}
\value{
If check passes then \code{assert} returns invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is a \link{ParameterSetCollection}.
}
\examples{
# FALSE
testParameterSetCollection(5)
# TRUE
testParameterSetCollection(ParameterSetCollection$new(Binom = Binomial$new()$parameters()))
}
