% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixMatrix.R
\name{mixMatrix}
\alias{mixMatrix}
\title{Mix Matrix Distributions into a new Matdist}
\usage{
mixMatrix(mds, weights = "uniform")
}
\arguments{
\item{mds}{\code{(list())}\cr
List of \link{Matdist}s, should have same number of rows and columns.}

\item{weights}{\code{(character(1)|numeric())}\cr
Individual distribution weights. Default uniform weighting (\code{"uniform"}).}
}
\description{
Given \code{m} matrix distributions distributions of length \code{N},
creates a new Matdist by summing over the weighted cdfs. Note that this
method does \emph{not} create a \link{MixtureDistribution} but a new \link{Matdist}.
Assumes Matrix distributions have the same number of columns, otherwise use
\code{mixturiseVector(lapply(mds, as.VectorDistribution))}.
}
\details{
This method returns a new \link{Matdist} which is less flexible than a
\link{MixtureDistribution} which has parameters (i.e. \code{weights}) that can be
updated after construction.
}
\examples{
m1 <- as.Distribution(
 t(apply(matrix(runif(25), 5, 5, FALSE,
                 list(NULL, 1:5)), 1,
         function(x) x / sum(x))),
 fun = "pdf"
)
m2 <- as.Distribution(
 t(apply(matrix(runif(25), 5, 5, FALSE,
                 list(NULL, 1:5)), 1,
         function(x) x / sum(x))),
 fun = "pdf"
)
# uniform mixing
m3 <- mixMatrix(list(m1, m2))

# un-uniform mixing
m4 <- mixMatrix(list(m1, m2), weights = c(0.1, 0.9))

m1$cdf(3)
m2$cdf(3)
m3$cdf(3)
m4$cdf(3)

}
\seealso{
\link{mixturiseVector}
}
