% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HurdlePoisson.R
\name{cdf.HurdlePoisson}
\alias{cdf.HurdlePoisson}
\title{Evaluate the cumulative distribution function of a hurdle Poisson distribution}
\usage{
\method{cdf}{HurdlePoisson}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{A \code{HurdlePoisson} object created by a call to \code{\link[=HurdlePoisson]{HurdlePoisson()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link{phpois}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the cumulative distribution function of a hurdle Poisson distribution
}
\examples{
## set up a hurdle Poisson distribution
X <- HurdlePoisson(lambda = 2.5, pi = 0.75)
X

## standard functions
pdf(X, 0:8)
cdf(X, 0:8)
quantile(X, seq(0, 1, by = 0.75))

## cdf() and quantile() are inverses for each other
cdf(X, quantile(X, 0.3))
quantile(X, cdf(X, 3))

## density visualization
plot(0:8, pdf(X, 0:8), type = "h", lwd = 2)

## corresponding sample with histogram of empirical frequencies
set.seed(0)
x <- random(X, 500)
hist(x, breaks = -1:max(x) + 0.5)
}
