% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exponential.R
\name{pdf.Exponential}
\alias{pdf.Exponential}
\alias{log_pdf.Exponential}
\title{Evaluate the probability density function of an Exponential distribution}
\usage{
\method{pdf}{Exponential}(d, x, drop = TRUE, ...)

\method{log_pdf}{Exponential}(d, x, drop = TRUE, ...)
}
\arguments{
\item{d}{An \code{Exponential} object created by a call to \code{\link[=Exponential]{Exponential()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{...}{Arguments to be passed to \code{\link[stats]{dexp}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the probability density function of an Exponential distribution
}
\examples{

set.seed(27)

X <- Exponential(5)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 4)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
