% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fadLad.R
\name{survivors}
\alias{survivors}
\title{Proportions of survivorship}
\usage{
survivors(x, tax = "genus", bin = "stg", method = "forward",
  noNAStart = FALSE, fl = NULL)
}
\arguments{
\item{x}{\code{(data.frame)} The data frame containing fossil occurrences.}

\item{tax}{\code{(character)} The variable  name of the occurring taxa (variable type: \code{factor} or \code{character}).}

\item{bin}{\code{(character)} The variable name of the time slice numbers of the particular occurrences (variable type: \code{numeric}). Bin numbers should be in ascending order,can contain \code{NA}s, it can start from a number other than 1 and must not start with 0.}

\item{method}{\code{(character)} Either \code{"forward"} or \code{"backward"}.}

\item{noNAStart}{\code{(logical)} Useful when the dataset does not start from bin \code{1}. Then \code{noNAStart=TRUE} will cut the first part of the resulting table, 
so the first row will contain the estimates for the lowest bin number.}

\item{fl}{\code{(matrix} or \code{data.frame}). If so desired, the function can be run on an FAD-LAD dataset, output by the \code{\link{fadlad}} function.}
}
\description{
This function will calculate both forward and backward survivorship proportions from a given occurrence dataset or FAD-LAD matrix.
}
\details{
Proportions of survivorship are great tools to visualize changes in the composition of a group over time (Raup, 1978). The curves show how a once coexisting set of taxa, called a cohort, loses its participants (forward survivorship) as time progress, or gains its elements as time is analyzed backwards.
Each value corresponds to a cohort in a bin (\emph{a}) and one other bin (\emph{b}). The value expresses what proportion of the analyzed cohort (present together in bin \emph{a}) is present in bin \emph{b}.

References:

Raup, D. M. (1978). Cohort analysis of generic survivorship. Paleobiology, 4(1), 1-15.
}
\examples{
data(corals)
surv<-survivors(corals, tax="genus", bin="stg", method="forward")

# plot
data(stages)
tsplot(stages, shading="series", boxes="sys", xlim=c(260,0), 
  ylab="proportion of survivors present", ylim=c(0.01,1),plot.args=list(log="y"))
  
for(i in 1:ncol(surv)) lines(stages$mid, surv[,i])

}
