% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_pd.R
\name{div_pd}
\alias{div_pd}
\alias{div_pd.numeric}
\alias{div_pd.species_distribution}
\title{Faith's Phylogenetic Diversity of a Community}
\usage{
div_pd(x, tree, ...)

\method{div_pd}{numeric}(x, tree, prune = FALSE, as_numeric = FALSE, ..., check_arguments = TRUE)

\method{div_pd}{species_distribution}(
  x,
  tree,
  prune = FALSE,
  gamma = FALSE,
  as_numeric = FALSE,
  ...,
  check_arguments = TRUE
)
}
\arguments{
\item{x}{An object, that may be a named numeric vector (names are species names)
containing abundances or probabilities,
or an object of class \link{abundances} or \link{probabilities}.}

\item{tree}{an ultrametric, phylogenetic tree.
May be an object of class \link{phylo_divent}, \link[ape:read.tree]{ape::phylo}, \link[ade4:phylog]{ade4::phylog} or \link[stats:hclust]{stats::hclust}.}

\item{...}{Unused.}

\item{prune}{What to do when some species are in the tree but not in \code{x}?
If \code{TRUE}, the tree is pruned to keep species of \code{x} only.
The height of the tree may be changed if a pruned branch is related to the root.
If \code{FALSE} (default), the length of branches of missing species is not summed
but the height of the tree is never changed.}

\item{as_numeric}{if \code{TRUE}, a number or a numeric vector is returned rather than a tibble.}

\item{check_arguments}{if \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}

\item{gamma}{if \code{TRUE}, \eqn{\gamma} diversity, i.e. diversity of the metacommunity, is computed.}
}
\value{
A tibble with the site names, the estimators used and the estimated diversity.
}
\description{
Estimate PD \insertCite{Faith1992}{divent} or FD \insertCite{Petchey2002}{divent} from
abundance or probability data and a phylogenetic or functional dendrogram.
}
\details{
Estimators to deal with incomplete sampling are not implemented.
Use function \link{div_hill} with argument \code{q = 0} if they are needed.

PD and FD are defined as the total length of the branches of the tree.

All species of the \code{species_distribution} must be found in the tips of the
\code{tree}.
}
\examples{
# diversity of each community
div_pd(paracou_6_abd, tree = paracou_6_taxo)

# gamma diversity
div_pd(paracou_6_abd, tree = paracou_6_taxo, gamma = TRUE)

}
\references{
\insertAllCited{}
}
