% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hhi.R, R/simpson.R
\name{ds_hhi}
\alias{ds_hhi}
\alias{hhi}
\alias{ds_simpson}
\alias{simpson}
\title{Compute Herfindahl-Hirshman Index}
\usage{
ds_hhi(.data, .cols, .name)

hhi(..., .data = dplyr::cur_data_all())

ds_simpson(.data, .cols, .name)

simpson(..., .data = dplyr::cur_data_all())
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with.}

\item{.name}{name for column with HHI. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_hhi from hhi}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
This is equivalent to the Simpson Index.
}
\examples{
data("de_county")
ds_hhi(de_county, starts_with('pop_'))
ds_hhi(de_county, starts_with('pop_'), 'blau')
}
\concept{div}
