% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episode_group.R
\name{episodes}
\alias{episodes}
\alias{episodes_wf_splits}
\alias{fixed_episodes}
\alias{rolling_episodes}
\alias{episode_group}
\title{Link events  to chronological episodes.}
\usage{
episodes(
  date,
  case_length = Inf,
  episode_type = "fixed",
  recurrence_length = case_length,
  episode_unit = "days",
  strata = NULL,
  sn = NULL,
  episodes_max = Inf,
  rolls_max = Inf,
  case_overlap_methods = 8,
  recurrence_overlap_methods = case_overlap_methods,
  skip_if_b4_lengths = FALSE,
  data_source = NULL,
  data_links = "ANY",
  custom_sort = NULL,
  skip_order = Inf,
  reference_event = "last_record",
  case_for_recurrence = FALSE,
  from_last = FALSE,
  group_stats = FALSE,
  display = "none",
  case_sub_criteria = NULL,
  recurrence_sub_criteria = case_sub_criteria,
  case_length_total = 1,
  recurrence_length_total = case_length_total
)

episodes_wf_splits(
  date,
  case_length = Inf,
  episode_type = "fixed",
  recurrence_length = case_length,
  episode_unit = "days",
  strata = NULL,
  sn = NULL,
  episodes_max = Inf,
  rolls_max = Inf,
  case_overlap_methods = 8,
  recurrence_overlap_methods = case_overlap_methods,
  skip_if_b4_lengths = FALSE,
  data_source = NULL,
  data_links = "ANY",
  custom_sort = NULL,
  skip_order = Inf,
  reference_event = "last_record",
  case_for_recurrence = FALSE,
  from_last = FALSE,
  group_stats = FALSE,
  display = "none",
  case_sub_criteria = NULL,
  recurrence_sub_criteria = case_sub_criteria,
  case_length_total = 1,
  recurrence_length_total = case_length_total
)

fixed_episodes(
  date,
  case_length = Inf,
  episode_unit = "days",
  to_s4 = TRUE,
  case_overlap_methods = 8,
  deduplicate = FALSE,
  display = "none",
  bi_direction = FALSE,
  recurrence_length = case_length,
  recurrence_overlap_methods = case_overlap_methods,
  include_index_period = TRUE,
  ...,
  overlap_methods = 8,
  overlap_method = 8,
  x
)

rolling_episodes(
  date,
  case_length = Inf,
  recurrence_length = case_length,
  episode_unit = "days",
  to_s4 = TRUE,
  case_overlap_methods = 8,
  recurrence_overlap_methods = case_overlap_methods,
  deduplicate = FALSE,
  display = "none",
  bi_direction = FALSE,
  include_index_period = TRUE,
  ...,
  overlap_methods = 8,
  overlap_method = 8,
  x
)

episode_group(df, ..., episode_type = "fixed")
}
\arguments{
\item{date}{\code{[date|datetime|integer|\link{number_line}]}. Event date or period.}

\item{case_length}{\code{[integer|\link{number_line}]}. Duration from index event distinguishing one \code{"case"} from another.
This is the case window.}

\item{episode_type}{\code{[character]}. Options are \code{"fixed"} (default), \code{"rolling"} or \code{"recursive"}. See \code{Details}.}

\item{recurrence_length}{\code{[integer|\link{number_line}]}. Duration from the last \code{"duplicate"} event distinguishing a \code{"recurrent"} event from its index event. This is the recurrence window.}

\item{episode_unit}{\code{[character]}. Time units for \code{case_length} and \code{recurrence_length}. Options are "seconds", "minutes", "hours", "days" (default), "weeks", "months" or "years". See \code{diyar::episode_unit}.}

\item{strata}{\code{[atomic]}. Subsets of the dataset. Episodes are created separately for each \code{strata}.}

\item{sn}{\code{[integer]}. Unique record identifier. Useful for creating familiar \code{\link[=epid-class]{epid}} identifiers.}

\item{episodes_max}{\code{[integer]}. The maximum number of episodes permitted within each \code{strata}.}

\item{rolls_max}{\code{[integer]}. Maximum number of times the index \code{"case"} can recur. Only used if \code{episode_type} is \code{"rolling"}.}

\item{case_overlap_methods}{\code{[character|integer]}. Methods of overlap considered when tracking duplicates of \code{"case"} events. See (\code{\link{overlaps}})}

\item{recurrence_overlap_methods}{\code{[character|integer]}. Methods of overlap considered when tracking duplicates of \code{"recurrent"} events. See (\code{\link{overlaps}})}

\item{skip_if_b4_lengths}{\code{[logical]}. If \code{TRUE} (default), when using lagged \code{case_length} or \code{recurrence_length}, \code{events} before the cut-off point or period are skipped.}

\item{data_source}{\code{[character]}. Unique data source identifier. Adds the list of datasets in each episode to the \code{\link[=epid-class]{epid}}. Useful when the dataset has data from multiple sources.}

\item{data_links}{\code{[list|character]}. A set of \code{data_sources} required in each \code{\link[=epid-class]{epid}}. An episode without records from these \code{data_sources} will be unlinked. See \code{Details}.}

\item{custom_sort}{\code{[atomic]}. Preferential order for selecting index or reference events.}

\item{skip_order}{\code{[integer]}. \code{"nth"} level of \code{custom_sort}. Episodes with index events beyond this level of preference are skipped.}

\item{reference_event}{\code{[character]}. Specifies which of the duplicates are used as reference events for subsequent windows. Options are "last_record" (default), "last_event", "first_record" or ""firs_event".}

\item{case_for_recurrence}{\code{[logical]}. If \code{TRUE}, both \code{"case"} and \code{"recurrent"} events will have a case window.
If \code{FALSE} (default), only \code{case events} will have a \code{case window}. Only used if \code{episode_type} is \code{"rolling"}.}

\item{from_last}{\code{[logical]}. Chronological order of episode tracking i.e. ascending (\code{TRUE}) or descending (\code{FALSE}).}

\item{group_stats}{\code{[logical]}. If \code{TRUE} (default), episode-specific information like episode start and end dates are returned.}

\item{display}{\code{[character]}. The progress messages printed on screen. Options are; \code{"none"} (default), \code{"progress"} and \code{"stats"}.}

\item{case_sub_criteria}{\code{[\link{sub_criteria}]}. Matching conditions for "case" windows in addition to temporal links.}

\item{recurrence_sub_criteria}{\code{[\link{sub_criteria}]}. Matching conditions for "recurrence" windows in addition to temporal links.}

\item{case_length_total}{\code{[integer|\link{number_line}]}. Minimum number of matched case windows required for an episode.}

\item{recurrence_length_total}{\code{[integer|\link{number_line}]}. Minimum number of matched recurrence windows required for an episode.}

\item{to_s4}{\code{[logical]}. Deprecated. Output type - \code{\link[=epid-class]{epid}} (\code{TRUE}) or \code{data.frame} (\code{FALSE}).}

\item{deduplicate}{\code{[logical]}. Deprecated. If \code{TRUE}, \code{"duplicate"} events are excluded from the \code{\link[=epid-class]{epid}}.}

\item{bi_direction}{\code{[logical]}. Deprecated. If \code{TRUE}, \code{"duplicate"} events before and after the index event are tracked.}

\item{include_index_period}{\code{[logical]}. Deprecated. If \code{TRUE}, events overlapping with the index event or period are linked even if they are outside the cut-off period.}

\item{...}{Arguments passed to \code{episodes}.}

\item{overlap_methods}{\code{[character]}. Deprecated. Please use \code{case_overlap_methods} or \code{recurrence_overlap_methods}. Methods of overlap considered when tracking duplicate event. See (\code{\link{overlaps}})}

\item{overlap_method}{\code{[character]}. Deprecated. Please use \code{case_overlap_methods} or \code{recurrence_overlap_methods}. Methods of overlap considered when tracking event. All event are checked by the same set of \code{overlap_method}.}

\item{x}{\code{[date|datetime|integer|\link{number_line}]}. Deprecated. Record date or period. Please use \code{date}.}

\item{df}{\code{[data.frame]}. Deprecated. One or more datasets appended together. See \code{Details}.}
}
\value{


\code{\link[=epid-class]{epid}}
}
\description{
Link events with matching attributes and within specified durations of each other.
Each set of linked records are assigned a unique identifier with relevant group-level information.
}
\details{
All dated records within a specified duration of an index record are linked together as an episode.
By default, this process occurs in ascending order, beginning with the earliest event.
This can be changed to a descending (\code{from_last}) or custom order (\code{custom_sort}).
Ties are always broken by the chronological order of events.

A \code{"fixed"} episode has a fixed maximum duration determined by \code{case_length}, while a \code{"rolling"} episode can continue to recur.
A \code{"rolling"} episode will persist as long as is specified by \code{rolls_max}.

\bold{\code{episodes()}} will categorise records into 5 type of events;

\itemize{
\item \code{"Case"} - Index event of the episode.
\item \code{"Duplicate_C"} - Duplicate of the index event.
\item \code{"Recurrent"} - Recurrence of the index event.
\item \code{"Duplicate_R"} - Duplicate of the recurrent event.
\item \code{"Skipped"} - Records excluded from the episode tracking process.
}

Every element in \code{data_links} must be named \code{"l"} (links) or \code{"g"} (groups).
Unnamed elements of \code{data_links} will be assumed to be \code{"l"}.
\itemize{
\item If named \code{"l"}, only groups with records from every listed \code{data_source} will be unlinked.
\item If named \code{"g"}, only groups with records from any listed \code{data_source} will be unlinked.
}

\emph{\code{NA} values in \code{strata} excludes records from the episode tracking process}

\bold{\code{episodes_wf_splits()}} is a wrapper function of \bold{\code{episode_group()}} which reframes the data before the episode tracking process.
This aims to reduce the overall processing time for the tracking process. See \code{vignette("episodes")} for further details.

\bold{\code{episode_group()}} has been retired.
It now only exists to support previous code with minimal input from users.
Moving forward, please use \bold{\code{episodes()}}.

\bold{\code{rolling_episodes()}} and \bold{\code{rolling_episodes()}} are convenience functions
to support previous code with minimal input from users.
Moving forward, please use \bold{\code{episodes()}}.

See \code{vignette("episodes")} for more information.
}
\examples{
data(infections)
data(hospital_admissions)

db_1 <- infections
db_1$patient_id <- c(rep("PID 1",8), rep("PID 2",3))

# Fixed episodes
# One 16-day (15-day difference) episode per patient
db_1$epids_p <- episodes(date = db_1$date,
                         strata = db_1$patient_id,
                         case_length = 15,
                         episodes_max = 1)
# Rolling episodes
# 16-day episodes with recurrence periods of 11 days
db_1$rd_b <- episodes(date = db_1$date,
                     case_length = 15,
                     recurrence_length = 10,
                     episode_type = "rolling")

# Interval grouping
hospital_admissions$admin_period <- number_line(hospital_admissions$admin_dt,
                                                hospital_admissions$discharge_dt)
admissions <- hospital_admissions[c("admin_period","epi_len")]

# Episodes of overlapping periods of admission
hospital_admissions$epids_i <- episodes(date = hospital_admissions$admin_period,
                                       case_length = 0,
                                       case_overlap_methods = "inbetween")

}
\seealso{
\code{\link{custom_sort}}; \code{\link{sub_criteria}}; \code{\link[=windows]{epid_length}}; \code{\link[=windows]{epid_window}}; \code{\link{partitions}}; \code{\link{links}}; \code{\link{overlaps}}; \code{\link{number_line}}; \code{\link{schema}}
}
