% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tdlnm.R
\name{tdlnm}
\alias{tdlnm}
\title{Treed Distributed Lag Non-Linear Models (Deprecated)}
\usage{
tdlnm(
  formula,
  data,
  exposure.data,
  exposure.splits = 20,
  exposure.se = sd(exposure.data)/2,
  n.trees = 20,
  n.burn = 1000,
  n.iter = 2000,
  n.thin = 5,
  family = "gaussian",
  binomial.size = 1,
  formula.zi = NULL,
  tree.params = c(0.95, 2),
  step.prob = c(0.25, 0.25),
  monotone = FALSE,
  monotone.gamma0 = rep(0, ncol(exposure.data)),
  monotone.sigma = diag(ncol(exposure.data)) * 1.502^2,
  monotone.tree.time.params = c(0.95, 2),
  monotone.tree.exp.params = c(0.95, 2),
  monotone.time.kappa = NULL,
  shrinkage = ifelse(monotone, FALSE, TRUE),
  subset = NULL,
  lowmem = FALSE,
  verbose = TRUE,
  diagnostics = FALSE,
  initial.params = NULL,
  debug = FALSE,
  ...
)
}
\arguments{
\item{formula}{object of class formula, a symbolic description of the fixed
effect model to be fitted, e.g. y ~ a + b}

\item{data}{data frame containing variables used in the formula}

\item{exposure.data}{numerical matrix of complete exposure data with same
length as data}

\item{exposure.splits}{scalar indicating the number of splits (divided
evenly across quantiles of the exposure data) or list with two components:
'type' = 'values' or 'quantiles', and 'split.vals' = a numerical
vector indicating the corresponding exposure values or quantiles for splits.
Setting exposure.splits equal to 0 will change the model to a distributed lag
model, which assumes a linear effect of exposure.}

\item{exposure.se}{numerical matrix of exposure standard errors with same
size as exposure.data or a scalar smoothing factor representing a uniform
smoothing factor applied to each exposure measurement, defaults to sd(exposure.data)/2}

\item{n.trees}{integer for number of trees in ensemble, default = 20}

\item{n.burn}{integer for length of burn-in, >=2000 recommended}

\item{n.iter}{integer for number of iterations to run model after burn-in >=5000 recommended}

\item{n.thin}{integer thinning factor, i.e. keep every fifth iteration}

\item{family}{'gaussian' for continuous response, or 'logit' for binomial
response with logit link}

\item{binomial.size}{integer type scalar (if all equal, default = 1) or
vector defining binomial size for 'logit' family}

\item{formula.zi}{object of class formula, a symbolic description of the ZI
model to be fitted, e.g. y ~ a + b. This only applies to ZINB where covariates for
ZI model is different from NB model. This is same as the main formula by default}

\item{tree.params}{numerical vector of alpha and beta hyperparameters
controlling tree depth (see Bayesian CART, 1998), default: alpha = 0.95,
beta = 2}

\item{step.prob}{numerical vector for probability of 1) grow/prune, and
2) change, defaults to (0.25, 0.25) or equal
probability of each step for tree updates}

\item{monotone}{FALSE (default) or TRUE: estimate monotone effects}

\item{monotone.gamma0}{---------UPDATE---------}

\item{monotone.sigma}{---------UPDATE---------}

\item{monotone.tree.time.params}{---------UPDATE---------}

\item{monotone.tree.exp.params}{---------UPDATE---------}

\item{monotone.time.kappa}{---------UPDATE---------}

\item{shrinkage}{int, 1 (default) turn on tree-specific shrinkage priors,
0 turn off}

\item{subset}{integer vector to analyze only a subset of data and exposures}

\item{lowmem}{FALSE (default) or TRUE: turn on memory saver for DLNM, slower computation time}

\item{verbose}{TRUE (default) or FALSE: print progress bar output}

\item{diagnostics}{TRUE or FALSE (default) keep model diagnostic such as
terminal nodes, acceptance details, etc.}

\item{initial.params}{initial parameters for fixed effects model, FALSE = none (default), 
"glm" = generate using GLM, or user defined, length must equal number of parameters in fixed effects model}

\item{debug}{if TRUE, outputs debugging messages}

\item{...}{NA}
}
\value{
object of class 'tdlnm' or 'tdlm'
}
\description{
TDLNM is a method for estimating Distributed Lag
Linear and Non-Linear Models (DLMs/DLNMs). It operates by building an
ensemble of regression trees, which each partition the exposure-time-
response surface and make estimates at each sector. Trees from the ensemble
each contribute a partial estimate of the exposure-time surface, while
controlling for a model given by 'formula'.
}
\details{
tdlnm

Model is recommended to be run for at minimum 5000 burn-in iterations
followed by 15000 sampling iterations with a thinning factor of 10.
Convergence can be checked by re-running the model and validating consistency
of results.
}
