% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm.R
\name{pull_tbl}
\alias{pull_tbl}
\title{Retrieve a table}
\usage{
pull_tbl(dm, table, ..., keyed = FALSE)
}
\arguments{
\item{dm}{A \code{dm} object.}

\item{table}{One unquoted table name for \code{pull_tbl.dm()}, ignored for \code{pull_tbl.dm_zoomed()}.}

\item{...}{These dots are for future extensions and must be empty.}

\item{keyed}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Set to \code{TRUE} to return objects of the internal class \code{"dm_keyed_tbl"}
that will contain information on primary and foreign keys
in the individual table objects.
This allows using dplyr workflows on those tables and later reconstruct them
into a \code{dm} object.
See \code{vignette("tech-dm-keyed")} for details.}
}
\value{
The requested table
}
\description{
This generic has methods for both \code{dm} classes:
\enumerate{
\item With \code{pull_tbl.dm()} you can chose which table of the \code{dm} you want to retrieve.
\item With \code{pull_tbl.dm_zoomed()} you will retrieve the zoomed table in the current state.
}
}
\examples{
\dontshow{if (rlang::is_installed("nycflights13")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# For an unzoomed dm you need to specify the table to pull:
dm_nycflights13() \%>\%
  pull_tbl(airports)

# If zoomed, pulling detaches the zoomed table from the dm:
dm_nycflights13() \%>\%
  dm_zoom_to(airports) \%>\%
  pull_tbl()
\dontshow{\}) # examplesIf}
}
