% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\docType{class}
\name{dmbc_fit-class}
\alias{dmbc_fit-class}
\title{An S4 class to represent the results of fitting DMBC model.}
\description{
An S4 class to represent the results of fitting DMBC model using a single
  Markov Chain Monte Carlo chain.
}
\section{Slots}{

\describe{
\item{\code{z.chain}}{An object of class \code{array}; posterior draws from
the MCMC algorithm for the (untransformed) latent configuration \eqn{Z}.}

\item{\code{z.chain.p}}{An object of class \code{array}; posterior draws from
the MCMC algorithm for the (Procrustes-transformed) latent configuration
\eqn{Z}.}

\item{\code{alpha.chain}}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\alpha} parameters.}

\item{\code{eta.chain}}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\eta} parameters.}

\item{\code{sigma2.chain}}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\sigma^2} parameters.}

\item{\code{lambda.chain}}{An object of class \code{matrix}; posterior draws
from the MCMC algorithm for the \eqn{\lambda} parameters.}

\item{\code{prob.chain}}{An object of class \code{array}; posterior draws
from the MCMC algorithm for the cluster membership probabilities.}

\item{\code{x.ind.chain}}{An object of class \code{array}; posterior draws
from the MCMC algorithm for the cluster membership indicators.}

\item{\code{x.chain}}{An object of class \code{matrix}; posterior draws from
the MCMC algorithm for the cluster membership labels.}

\item{\code{accept}}{An object of class \code{matrix}; final acceptance rates
for the MCMC algorithm.}

\item{\code{diss}}{An object of class \code{list}; list of observed
dissimilarity matrices.}

\item{\code{dens}}{An object of class \code{list}; list of log-likelihood,
log-prior and log-posterior values at each iteration of the MCMC simulation.}

\item{\code{control}}{An object of class \code{list}; list of the control
parameters (number of burnin and sample iterations, number of MCMC chains,
etc.). See \code{\link{dmbc_control}()} for more information.}

\item{\code{prior}}{An object of class \code{list}; list of the prior
hyperparameters. See \code{\link{dmbc_prior}()} for more information.}

\item{\code{dim}}{An object of class \code{list}; list of dimensions for
the estimated model, i.e. number of objects (\emph{n}), number of latent
dimensions (\emph{p}), number of clusters (\emph{G}), and number of
subjects (\emph{S}).}

\item{\code{model}}{An object of class \code{\link{dmbc_model}}.}
}}

\examples{
showClass("dmbc_fit")

}
\references{
Venturini, S., Piccarreta, R. (2019), "A Bayesian Approach for Model-Based
  Clustering of Several Binary Dissimilarity Matrices: the \pkg{dmbc}
  Package in \code{R}", Technical report.
}
