% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_classes.R
\name{initialize,dmbc_config-method}
\alias{initialize,dmbc_config-method}
\alias{dmbc_config-initialize}
\title{Create an instance of the \code{dmbc_config} class using new/initialize.}
\usage{
\S4method{initialize}{dmbc_config}(
  .Object,
  Z.est = array(),
  Z.sd = array(),
  cluster = numeric(),
  est = character(),
  n = numeric(),
  S = numeric(),
  p = numeric(),
  G = numeric(),
  family = character(),
  chain = numeric(),
  labels = character()
)
}
\arguments{
\item{.Object}{Prototype object from the class \code{\link{dmbc_config}}.}

\item{Z.est}{An array containing the estimate of the latent
configuration for a DMBC model.}

\item{Z.sd}{An array containing the standard deviation of the latent
configuration for a DMBC model.}

\item{cluster}{A numeric vector providing the estimated group
membership for the \emph{S} subjects in the data.}

\item{est}{A length-one character vector providing the estimate type
returned in \code{Z.est}. Possible values are \code{mean} (posterior
mean), \code{median} (posterior median), \code{ml} (maximum likelihood)
and \code{map} (maximum-a-posteriori).}

\item{n}{A length-one numeric vector providing the number of objects.}

\item{S}{A length-one numeric vector providing the number of subjects.}

\item{p}{A length-one numeric vector providing the number of latent
dimensions.}

\item{G}{A length-one numeric vector providing the number of clusters.}

\item{family}{An object of class \code{list}; named list with
elements representing the parameter estimates corresponding to different
values of \emph{p} and \emph{G}.}

\item{chain}{A length-one numeric vector representing the ID of
the MCMC chain used to compute the estimates.}

\item{labels}{A character vector for the (optional) strings to use
in the plots for labeling the objects.}
}
\description{
Create an instance of the \code{dmbc_config} class using new/initialize.
}
\author{
Sergio Venturini \email{sergio.venturini@unito.it}
}
