% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bmds.R
\name{adjust_x}
\alias{adjust_x}
\title{Adjustment of the center and orientation of a latent configuration.}
\usage{
adjust_x(x)
}
\arguments{
\item{x}{Numeric matrix containing the latent configuration.}
}
\value{
A list with elements:
\describe{
  \item{\code{x}}{A real matrix containing the adjusted latent
                  configuration.}
  \item{\code{Sig_x}}{The variance and covariance matrix of the adjusted
                      latent configuration.}
}
}
\description{
\code{adjust_x} adjusts the center and orientation of a latent configuration
  in Bayesian (metric) multidimensional scaling (BMDS).
}
\examples{
n <- 100
nr <- 20
nc <- floor(n/nr)
x <- matrix(rnorm(1:n), nrow = nr, ncol = nc)
adj_x <- adjust_x(x)
adj_x$x
adj_x$Sig_x
}
\seealso{
\code{\link{bmds}} for (one-way) Bayesian (metric) multidimensional
  scaling.
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
