% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dmbc_control.R
\name{dmbc_control}
\alias{dmbc_control}
\alias{control_dmbc}
\alias{check_control}
\title{Auxiliary Function for Controlling DMBC Model Fitting}
\usage{
dmbc_control(
  nsim = 5000,
  burnin = 10000,
  thin = 1,
  nchains = 1,
  threads = 1,
  seed = NULL,
  parallel = "no",
  z.prop = 1.5,
  alpha.prop = 0.75,
  random.start = TRUE,
  partition = NULL,
  method = "manhattan",
  procrustes = TRUE,
  relabel = TRUE,
  store.burnin = TRUE,
  verbose = FALSE
)

control_dmbc(
  nsim = 5000,
  burnin = 10000,
  thin = 1,
  nchains = 1,
  threads = 1,
  seed = NULL,
  parallel = "no",
  z.prop = 1.5,
  alpha.prop = 0.75,
  random.start = TRUE,
  partition = NULL,
  method = "manhattan",
  procrustes = TRUE,
  relabel = TRUE,
  store.burnin = TRUE,
  verbose = FALSE
)

check_control(control)
}
\arguments{
\item{nsim}{A length-one numeric vector for the number of draws to be taken
from the posterior distribution.}

\item{burnin}{A length-one numeric vector for the number of initial MCMC
iterations (usually to be discarded).}

\item{thin}{A length-one numeric vector for the number of iterations between
consecutive draws.}

\item{nchains}{A length-one numeric vector for the number of parallel chains to run.}

\item{threads}{A length-one numeric vector for the number of chains to run.
If greater than 1, package \pkg{\link{parallel}} is used to take advantage of any
multiprocessing or distributed computing capabilities that may be available.}

\item{seed}{An integer scalar. If supplied, provides the random number seed.}

\item{parallel}{A length-one character vector indicating the type of parallel
operation to be used (if any). Possible values are \code{multicore}
(which worksonly on Unix/mcOS), \code{snow} and \code{no} (i.e. serial
instead of parallel computing).}

\item{z.prop}{A length-one numeric vector providing the standard deviation of the
proposal distribution for the jump in the individual latent space
position.}

\item{alpha.prop}{A length-one numeric vector providing the standard deviation
of the proposal distribution for the jump in the individual random effect value.}

\item{random.start}{A length-one logical vector. If \code{TRUE} the starting
values are drawn randomly, otherwise a user-defined starting partition must
be provided through the \code{partition} argument.}

\item{partition}{A length-one numeric vector providing the user-defined
starting partition.}

\item{method}{A length-one character vector that specifies the distance
measure to use in determining the initial partition. Allowed values are
those from the \code{\link{dist}()} function.}

\item{procrustes}{A length-one logical vector. If \code{TRUE} the simulated
MCMC chains are post-processed through a Procrustes transformation.}

\item{relabel}{A length-one logical vector. If \code{TRUE} the simulated
MCMC chains are relabelled to address the label-switching problem.}

\item{store.burnin}{A logical scalar. If \code{TRUE}, the samples from the
burnin are also stored and returned.}

\item{verbose}{A logical scalar. If \code{TRUE}, causes information to be
printed out about the progress of the fitting.}

\item{control}{A list of control options.}
}
\value{
A named list with the control options as components.
}
\description{
{
\code{dmbc_control()} is an auxiliary function as user interface for
  \code{dmbc()} fitting. Typically only used when calling the \code{dmbc()}
  function. It is used to set parameters that affect the sampling but do
  not affect the posterior distribution.

\code{control_dmbc()} is an alias for \code{dmbc_control()}.

\code{check_control()} is an auxiliary function that verifies the
  correctness of the controls provided before a DMBC is fitted with
  \code{\link{dmbc}()}.
}
}
\examples{
\dontrun{
data(simdiss, package = "dmbc")
# Shorter run than default.
sim.fit <- dmbc(simdiss,
  control = dmbc_control(burnin = 1000, nsim = 2000, thin = 5, verbose = TRUE))
}

}
\seealso{
\code{\link{dmbc}()}
}
\author{
Sergio Venturini \email{sergio.venturini@unicatt.it}
}
\keyword{based}
\keyword{clustering}
\keyword{model}
