#' Gene expression dataset for two groups
#' 
#' `meso` is a list containing gene expression data from Mesothelioma tumors
#' generated by The Cancer Genome Atlas (TCGA) and obtained using the 
#' LinkedOmics portal. The first element in the list, named "gene_expression",
#' contains 32 samples (rows) with 150 genes (columns). The second element, 
#' named "groups", is a vector of length 32 indicating which group (stage ii 
#' or stage iv) each gene expression sample belongs to. See the "Package data"
#' vignette for details.
#' 
#' @format A list containing two items:
#' \describe{
#'   \item{$gene_expression}{A 32 by 150 matrix of gene expression values}
#'   \item{$groups}{A vector of length 32 indicating which group (stageii or
#'   stageiv) each of the rows in the gene expression data belong to.}
#' }
#' 
#' @source \url{http://www.linkedomics.org/data_download/TCGA-GBMLGG/}
"meso"

#' Reactome pathway list for Homo sapiens
#' 
#' This is a pathway list obtained from \code{\link{get_reactome_pathways}}
#' with `species = "human"` (used `reactome.db` version 1.68.0). 
#' Only pathways with "p53" in their name are retained (to subset on some
#' cancer-related pathways). The list contains 13 total pathways. See the 
#' "Package data" vignette for details.
#' 
#' @format A list of 13 vectors each containing a set of entregene IDs.
#' 
"p53_pathways"


#' Default mapping for entrezgene IDs and HGNC gene symbols 
#' 
#' This dataset is used by default if the connection to biomaRt fails. It
#' is highly recommended to retry the function call that attempted to connect to 
#' biomaRt. Using this dataset in general may not produce the correct 
#' results.
#' 
#' @format A data.frame containing a mapping between entrezgene IDs and 
#' HGNC gene symbols.
#' 
"biomart_hsapiens"