% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bquote_list.R
\name{bquote_fun_list}
\alias{bquote_fun_list}
\title{Backquote a list of functions}
\usage{
bquote_fun_list(fun_list)
}
\arguments{
\item{fun_list}{List of functions}
}
\description{
Backquote a list of functions
}
\examples{

## Evaluate a list of functions
f1 <- function(x){x + 1}
f2 <- function(x){x + 8}

f1_ <- set_default(f1, list(x=10))
f2_ <- set_default(f2, list(x=10))

f1_(); f2_()

fn_list  <- list(f1_, f2_)
fn_list_ <- bquote_fun_list(fn_list)

eval(fn_list[[1]])     ## No
sapply(fn_list, eval)  ## No

eval(fn_list_[[1]])    ## Yes
sapply(fn_list_, eval) ## Yes

}
\seealso{
\code{\link[base:bquote]{base::bquote()}}, \code{\link[=set_default]{set_default()}}, \code{\link[=section_fun]{section_fun()}}
}
