% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/move_group.R
\name{move_group}
\alias{move_group}
\title{Move a group dynamically}
\usage{
move_group(
  dock_id,
  from,
  to,
  position = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{dock_id}{Dock unique id. When using modules the namespace is
automatically added.}

\item{from}{Group-id of a panel within the group that should be moved.}

\item{to}{Group-id of a panel within the group you want as a destination.}

\item{position}{Group position options: one of
\code{"left", "right", "top", "bottom", "center"}.}

\item{session}{shiny session object.
See \url{https://dockview.dev/docs/api/dockview/panelApi/}.}
}
\value{
This function is called for its side effect.
It sends a message to JavaScript through the current websocket connection,
leveraging the shiny session object.
}
\description{
move_group moves a group to a different position from
within a shiny server function.
The parameter from refers to the group-id you want to be moved.
Likewise to refers to the group-id of a group you want to
select as destination.
The difference between \code{\link[=move_group2]{move_group2()}} and \code{\link[=move_group]{move_group()}} is that
\code{\link[=move_group2]{move_group2()}} selects both
from and to by panel-id, whereas \code{\link[=move_group]{move_group()}} selects by group-id.
}
