% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_plot.R
\name{door_component_forestplot}
\alias{door_component_forestplot}
\title{Create DOOR component forest plot}
\usage{
door_component_forestplot(
  comp_table = NULL,
  y1 = NULL,
  y2 = NULL,
  n1 = NULL,
  n2 = NULL,
  data_type = c("freq", "prop"),
  summary_obj = NULL,
  conf_level = 0.95,
  ci_method = c("halperin", "ps_h", "ps_tanh")
)
}
\arguments{
\item{comp_table}{a data frame of DOOR components. See example.}

\item{y1, y2}{Numeric vectors of DOOR proportion or frequency distribution for group 1, group 2.
The entries should be ordered from most desirable to least desirable}

\item{n1, n2}{Sample sizes of group 1, group 2; must be specified if method = "prop"}

\item{data_type}{Either "freq" for frequency input or "prop" for proportion input
when using y1 and y2}

\item{summary_obj}{An object returned by \code{individual_to_summary()}; Alternative
input for y1 and y2}

\item{conf_level}{confidence level}

\item{ci_method}{method for confidence interval calculation; one of "halperin",
"ps_h", "ps_tanh"}
}
\value{
a forest plot object
}
\description{
Create DOOR component forest plot
}
\examples{
comp_table = data.frame(compname = c("A", "B"), trt = c(30, 20), ctr = c(40, 25))
y1 = c(60, 30, 10)
y2 = c(60, 30, 10)
door_component_forestplot(comp_table = comp_table,
                          y1 = y1,
                          y2 = y2)
}
