% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional.R
\name{vpc}
\alias{vpc}
\title{Variance Partition Components for dosresmeta Objects}
\usage{
vpc(object)
}
\arguments{
\item{object}{an object of class \code{dosresmeta} produced by \code{\link{dosresmeta}}.}
}
\value{
A vector containing the variance partition components for each non-referent observation.
}
\description{
Computes the Variance Partition Components for dose-response meta-analysis.
}
\examples{

## loading data
data("sim_os")

## Quadratic (one-stage) dose-response model
quadr <- dosresmeta(logrr ~ dose + I(dose^2), id = id, se = se, type = type,
                    cases = cases, n = n, data = sim_os, proc = "1stage")
                    
## Plot of the estimated vpc
plot(sim_os$dose[sim_os$se!=0], vpc(quadr), xlab = "dose")
lines(lowess(sim_os$dose[sim_os$se!=0], vpc(quadr)))
 
}
\references{
Goldstein H, Browne W, Rasbash J. Partitioning variation in multilevel models. 
Understanding Statistics: Statistical Issues in Psychology, Education, and the Social Sciences. 
2002 Dec 2;1(4):223-31.
}
\author{
Alessio Crippa, \email{alessio.crippa@ki.se}
}
