% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{downsize}
\alias{downsize}
\title{Function \code{downsize}. Main function of the \code{downsize} package.}
\usage{
downsize(big, small = NULL, downsize = getOption("downsize"), warn = TRUE,
  random = FALSE, length = NULL, dim = NULL, ncol = NULL, nrow = NULL)
}
\arguments{
\item{big}{Object to return if \code{downsize} is \code{FALSE} or \code{NULL}.}

\item{small}{Object to return if \code{downsize} is \code{TRUE} and all subsetter 
arguments such as \code{length} and \code{dim} are \code{NULL}.}

\item{downsize}{\code{TRUE}/\code{FALSE} value (\code{NULL} counts as \code{FALSE}), 
whether to replace \code{big} with a downsized object.
Defaults to the global option \code{downsize}, which you can check with
\code{getOption("downsize")} or the \code{\link{scaling}} function and set with functions
\code{\link{downsize}}, \code{\link{scale_down}} or \code{\link{scale_up}}.}

\item{warn}{\code{TRUE/FALSE} option to warn the user if \code{big} and \code{small}
are identical or \code{big} is smaller in memory than \code{small}.}

\item{random}{If \code{TRUE}, take a random subset of \code{big} instead
of the first few elements. For example, if \code{nrow == 3}, take a random 
3 rows instead of the first 3.}

\item{length}{Downsize \code{big} to this length if \code{downsize} is \code{TRUE}.}

\item{dim}{Downsize \code{big} to these dimensions if \code{downsize} is \code{TRUE}.}

\item{ncol}{Downsize \code{big} to this number of columns if \code{downsize} is \code{TRUE}.}

\item{nrow}{Downsize \code{big} to this number of rows if \code{downsize} is \code{TRUE}.}
}
\value{
A downsized object if \code{downsize} is \code{TRUE} and \code{big} otherwise.
}
\description{
Replace \code{big} with a downsized object 
if the \code{downsize} argument (or global \code{downsize} option) is \code{TRUE}.
}
\details{
If the \code{downsize} argument is \code{TRUE}, a downsized replacement 
for \code{big} will be returned. In this case, arguments \code{dim}, \code{length},
 etc. take precedence over \code{small}. If the \code{downsize} argument is not set 
manually, the global option \code{downsize} will be used. The \code{downsize} option 
can be toggled with functions \code{\link{scale_down}} and \code{\link{scale_up}}.
}
\seealso{
\code{\link{scale_down}}, \code{\link{scale_up}}, \code{\link{scaling}}
}

