% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\name{dbConnect,TeradataOdbcDriver-method}
\alias{dbConnect,TeradataOdbcDriver-method}
\alias{dbConnect}
\title{Connect to a Teradata ODBC compatible database}
\usage{
\S4method{dbConnect}{TeradataOdbcDriver}(
  drv,
  dsn = NULL,
  ...,
  timezone = "UTC",
  encoding = "UTF-8",
  bigint = c("integer64", "integer", "numeric", "character"),
  driver = NULL,
  server = NULL,
  DBCName = NULL,
  database = "",
  uid = NULL,
  pwd = NULL,
  charset = "ASCII",
  tmode = c("ANSI", "TERA"),
  dbms.name = NULL,
  .connection_string = NULL
)
}
\arguments{
\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{dsn}{The Data Source Name.}

\item{...}{Additional ODBC keywords, these will be joined with the other
arguments to form the final connection string.}

\item{timezone}{The Server time zone. Useful if the database has an internal
timezone that is \emph{not} 'UTC'. If the database is in your local timezone set
to \code{Sys.timezone()}. See \code{\link[=OlsonNames]{OlsonNames()}} for a complete list of available
timezones on your system.}

\item{encoding}{Alias of \code{charset}.}

\item{bigint}{The R type that \code{SQL_BIGINT} types should be mapped to,
default is \link[bit64:bit64-package]{bit64::integer64}, which allows the full range of 64 bit
integers.}

\item{driver}{The ODBC driver name.}

\item{server}{Alias of \code{DBCName}.}

\item{DBCName}{The server hostname.}

\item{database}{The database on the server.}

\item{uid}{The user identifier.}

\item{pwd}{The password to use.}

\item{charset}{Character Set. \code{"ASCII"}(default), \code{"UTF8"} or \code{"UTF16"}.}

\item{tmode}{TMODE. \code{"ANSI"}(default) or \code{"TERA"}.}

\item{dbms.name}{The database management system name. This should normally
be queried automatically by the ODBC driver. This name is used as the class
name for the OdbcConnect object returned from  \code{dbConnect()}. However if the
driver does not return a valid value it can be set manually with this
parameter.}

\item{.connection_string}{A complete connection string, useful if you are
copy pasting it from another source. If this argument is used any additional
arguments will be appended to this string.}
}
\description{
Connect to a Teradata ODBC compatible database
}
\details{
The connection string keywords are driver dependent. The parameters
documented here are common, but some drivers may not accept them. Please see
the specific driver documentation for allowed parameters,
\url{https://www.connectionstrings.com} is also a useful resource of example
connection strings for a variety of databases.
}
