% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dataframe.R
\name{as_data_frame}
\alias{as_data_frame}
\title{Coerce a list to a data frame.}
\usage{
as_data_frame(x)
}
\arguments{
\item{x}{A list. Each element of the list must have the same length.}
}
\description{
\code{as.data.frame} is effectively a thin wrapper around \code{data.frame},
and hence is rather slow (because it calls \code{data.frame} on each element
before \code{cbind}ing together). \code{as_data_frame} just verifies that
the list is structured correctly (i.e. named, and each element is same
length) then sets class and row name attributes.
}
\examples{
l <- list(x = 1:500, y = runif(500), z = 500:1)
df <- as_data_frame(l)

# Coercing to a data frame does not copy columns
changes(as_data_frame(l), as_data_frame(l))

# as_data_frame is considerably simpler/faster than as.data.frame
# making it more suitable for use when you have things that are
# lists
\dontrun{
l2 <- replicate(26, sample(letters), simplify = FALSE)
names(l2) <- letters
microbenchmark::microbenchmark(
  as_data_frame(l2),
  as.data.frame(l2)
)
}
}

