% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consecutive-id.R
\name{consecutive_id}
\alias{consecutive_id}
\title{Generate a unique identifier for consecutive combinations}
\usage{
consecutive_id(...)
}
\arguments{
\item{...}{Unnamed vectors. If multiple vectors are supplied, then they should
have the same length.}
}
\value{
A numeric vector the same length as the longest
element of \code{...}.
}
\description{
\code{consecutive_id()} generates a unique identifier that increments every time
a variable (or combination of variables) changes. Inspired by
\code{data.table::rleid()}.
}
\examples{
consecutive_id(c(TRUE, TRUE, FALSE, FALSE, TRUE, FALSE, NA, NA))
consecutive_id(c(1, 1, 1, 2, 1, 1, 2, 2))

df <- data.frame(x = c(0, 0, 1, 0), y = c(2, 2, 2, 2))
df \%>\% group_by(x, y) \%>\% summarise(n = n())
df \%>\% group_by(id = consecutive_id(x, y), x, y) \%>\% summarise(n = n())
}
