% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/dqset.seed.R
\name{dqRNGkind}
\alias{dqRNGkind}
\alias{dqrunif}
\alias{dqrnorm}
\alias{dqrexp}
\alias{dqset.seed}
\title{R interface}
\usage{
dqRNGkind(kind, normal_kind = "ignored")

dqrunif(n, min = 0, max = 1)

dqrnorm(n, mean = 0, sd = 1)

dqrexp(n, rate = 1)

dqset.seed(seed)
}
\arguments{
\item{kind}{string specifying the RNG (see details)}

\item{normal_kind}{ignored; included for compatibility with \code{\link{RNGkind}}}

\item{n}{number of  observations}

\item{min}{lower limit of the uniform distribution}

\item{max}{upper limit of the uniform distribution}

\item{mean}{mean value of the normal distribution}

\item{sd}{standard deviation of the normal distribution}

\item{rate}{rate of the exponential distribution}

\item{seed}{integer seed for the random number generator}
}
\value{
\code{dqrunif}, \code{dqrnorm}, and \code{dqrexp} return a numeric vector of length \code{n}.
}
\description{
The \code{dqrng} package provides several fast random number
  generators together with fast functions for generating random numbers
  according to a uniform, normal and exponential distribution. These
  functions are modeled after the \code{base} functions
  \code{\link{set.seed}}, \code{\link{RNGkind}}, \code{\link{runif}},
  \code{\link{rnorm}}, and \code{\link{rexp}}.
}
\details{
Supported RNG kinds:
\describe{
  \item{Mersenne-Twister}{The 64 bit variant of the well-known Mersenne-Twister,
   which is also used as default. This is a conservative default that allows
   you to take advantage of the fast distribution functions provided by dqrng
   while staying close to R's default RNG (32 bit Mersenne-Twister).}
  \item{pcg64}{The default 64 bit variant from the PCG family developed by
   Melissa O'Neill. See \url{http://www.pcg-random.org} for more details.}
  \item{Xoroshiro128+ and Xoshiro256+}{RNGs developed by David Blackman and
   Sebastiano Vigna. They are used as default RNGs in Erlang and Lua. See
    \url{http://xoshiro.di.unimi.it/} for more details.}
  \item{Threefry}{The 64 bit version of the 20 rounds Threefry engine as
   provided by \code{\link[sitmo]{sitmo-package}}}
}

The functions \code{dqrnorm} and \code{dqrexp} use the Ziggurat algorithm as
provided by \code{boost.random}.
}
\examples{
library(dqrng)
dqRNGkind("Xoroshiro128+")
dqset.seed(42)
dqrunif(5, min = 2, max = 10)
dqrexp(5, rate = 4)
dqrnorm(5, mean = 5, sd = 3)
}
\seealso{
\code{\link{set.seed}}, \code{\link{RNGkind}}, \code{\link{runif}},
         \code{\link{rnorm}}, and \code{\link{rexp}}
}
