% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loq_cv.R
\name{loq_cv}
\alias{loq_cv}
\title{Limits of quantifications estimation using coefficient of variation}
\usage{
loq_cv(x, subset.list = NULL, max.cv = 0.2, n.cuts = 100)
}
\arguments{
\item{x}{a \code{scluminex} object}

\item{subset.list}{list of analytes to estimate.
Default \code{NULL} (all analytes of the \code{scluminex} object).}

\item{max.cv}{is the target coeficient of variation by default 0.2}

\item{n.cuts}{is the number of cuts to search the coefficent of variation.
Default 100.}
}
\value{
Object of class \code{loq}.
}
\description{
Estimates the limits of quantification based on an approximation
of the coefficient
of variation.
}
\details{
For each value of the response, the estimated concentration
value and the approximated standard deviation is estimated.
The function \code{\link{invest}} with the delta method approach is used.
The coefficient of variation of the log10 concentration is calculated as the
\deqn{\sqrt{e^{ (SE \times  log(10))^2} - 1 }}
}
\examples{
# Load data and estimate models
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)$plate_1

igmodels <- scluminex("plate_1",sdf$standard, sdf$background,
lfct=c("SSl4", "SSl5"), bkg="ignore", fmfi="mfi", verbose=FALSE)

loq_cv(igmodels, max.cv=0.25, n.cuts=100)
}
\references{
Gottschalk PG, and Dunn JR. (2005).
Determining the error of dose estimates and minimum and maximum
acceptable concentrations from assays with nonlinear dose-response curves.
\emph{Comput Methods Programs Biomed} \bold{80}, 204-215.

Defawe OD, Fong Y, Vasilyeva E, Pickett M, Carter DK, Gabriel E,
Rerks-Ngarm S, Nityaphan S, Frahm N, McElrath MJ and De Rosa SC.(2012).
Optimization and qualification of a multiplex bead array to assess cytokine
and chemokine production by vaccine-specific cells.
\emph{J Immunol Methods} \bold{382}, 117-128.
}

