% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/loq_derivatives.R
\name{loq_derivatives}
\alias{loq_derivatives}
\title{Limits of quantifications estimation using derivatives}
\usage{
loq_derivatives(x, subset.list = NULL, ...)
}
\arguments{
\item{x}{a \code{scluminex} class object}

\item{subset.list}{list of analytes to estimate.
Default \code{NULL} (all analytes of the \code{scluminex} object)}

\item{...}{further arguments to be passed to \code{uniroot.all} function.}
}
\value{
Object of class \code{loq}.
}
\description{
Estimates the limits of quantification based on the second
order derivative of the functions.
}
\details{
The limits of quantification are based on the
maximum and minimum points of the second order derivative of the function.
The solution is based on the specific expressions of the derivatives.
The \code{\link[rootSolve]{uniroot.all}} function is used
in order to find the global maximum and minimum.
}
\examples{
# Load data and estimate models
data(ecdata)
data(mfidata)

dat <- mfidata[mfidata$plate=="plate_1" & mfidata$analyte=="FGF",]

sdf <- data_selection(dat, ecdata)[[1]]

igmodels <- scluminex("plate_1",sdf$standard, sdf$background,
                lfct=c("SSl4", "SSl5"),
                bkg="ignore",
                fmfi="mfi",
                verbose=FALSE)

loq_derivatives(igmodels)
}
\references{
Ritz C and Spiess AN (2008).
qpcR: an R package for sigmoidal model selection in q
uantitative real-time polymerase chain reaction analysis.
\emph{Bioinformatics} \bold{24}, 1549-51.
}

