% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timestamp.R
\name{time_stamps}
\alias{time_stamps}
\title{Write dummy timestamp files for
\code{make(..., parallelism = "Makefile")}.}
\usage{
time_stamps(config)
}
\arguments{
\item{config}{Internal master configuration list
produced by \code{\link[=drake_config]{drake_config()}}.}
}
\value{
nothing
}
\description{
For \code{"Makefile"} parallelism,
dummy timestamp files tell the Makefile
which targets need to be built and which can be skipped.
This function is for internal use only. It is only exported
to flesh out some of the examples in the help files.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
config <- drake_config(my_plan) # Master internal configuration list
time_stamps(config)
# Now look in '.drake/ts' for dummy timestamp files.
})
}
}
\keyword{internal}
