---
title: Example Report
author: You
output: html_document
---

Look how I read outputs from the drake cache."
Drake notices that `small`, `coef_regression2_small`,
and `large` are dependencies of the
future compiled output report file target, `report.md`.
Just be sure that the workflow plan command for the target `'report.md'`
has an explicit call to `knit()`, something like `knit('report.Rmd')` or
`knitr::knit(input = 'report.Rmd', quiet = TRUE)`.


```r
library(drake)
readd(small)
```

```
##             x y
## 1 -0.91139665 0
## 2  0.15039193 1
## 3 -0.04743851 2
## 4 -0.60066469 0
## 5 -1.11575698 2
```

```r
readd(coef_regression2_small)
```

```
## (Intercept)          x2 
##  0.97633288  0.04807998
```

```r
loadd(large)
head(large)
```

```
##              x y
## 1  0.742233385 0
## 2 -0.006206254 3
## 3  0.800312648 3
## 4  1.382540692 1
## 5  0.701660932 0
## 6  0.390635931 1
```
