% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hash.R
\name{long_hash}
\alias{long_hash}
\title{Get the long hash algorithm of a drake cache.}
\usage{
long_hash(cache = drake::get_cache(verbose = verbose),
  verbose = drake::default_verbose())
}
\arguments{
\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{logical or numeric, control printing to the console.
Use \code{pkgconfig} to set the default value of \code{verbose}
for your R session:
for example, \code{pkgconfig::set_config("drake::verbose" = 2)}.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: also print checks and cache info.
\item \code{3}: also print any potentially missing items.
\item \code{4}: also print imports and writes to the cache.
}}
}
\value{
A character vector naming a hash algorithm.
}
\description{
See the advanced storage tutorial
at \url{https://ropenscilabs.github.io/drake-manual/store.html}
for details.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
load_mtcars_example() # Get the code with drake_example("mtcars").
# Run the project and return the internal master configuration list.
config <- make(my_plan)
# Locate the storr cache.
cache <- config$cache
# Get the long hash algorithm of the cache.
long_hash(cache)
})
}
}
\seealso{
\code{\link[=default_short_hash_algo]{default_short_hash_algo()}},
\code{\link[=default_long_hash_algo]{default_long_hash_algo()}}
}
