% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_config.R
\name{drake_config}
\alias{drake_config}
\title{Ending of _drake.R for r_make() and friends
\lifecycle{maturing}}
\usage{
drake_config(
  plan,
  targets = NULL,
  envir = parent.frame(),
  verbose = 1L,
  hook = NULL,
  cache = drake::drake_cache(),
  fetch_cache = NULL,
  parallelism = "loop",
  jobs = 1L,
  jobs_preprocess = 1L,
  packages = rev(.packages()),
  lib_loc = NULL,
  prework = character(0),
  prepend = NULL,
  command = NULL,
  args = NULL,
  recipe_command = NULL,
  timeout = NULL,
  cpu = Inf,
  elapsed = Inf,
  retries = 0,
  force = FALSE,
  log_progress = TRUE,
  graph = NULL,
  trigger = drake::trigger(),
  skip_targets = FALSE,
  skip_imports = FALSE,
  skip_safety_checks = FALSE,
  lazy_load = "eager",
  session_info = NULL,
  cache_log_file = NULL,
  seed = NULL,
  caching = c("master", "worker"),
  keep_going = FALSE,
  session = NULL,
  pruning_strategy = NULL,
  makefile_path = NULL,
  console_log_file = NULL,
  ensure_workers = NULL,
  garbage_collection = FALSE,
  template = list(),
  sleep = function(i) 0.01,
  hasty_build = NULL,
  memory_strategy = "speed",
  spec = NULL,
  layout = NULL,
  lock_envir = TRUE,
  history = TRUE,
  recover = FALSE,
  recoverable = TRUE,
  curl_handles = list(),
  max_expand = NULL,
  log_build_times = TRUE,
  format = NULL,
  lock_cache = TRUE,
  log_make = NULL
)
}
\arguments{
\item{plan}{Workflow plan data frame.
A workflow plan data frame is a data frame
with a \code{target} column and a \code{command} column.
(See the details in the \code{\link[=drake_plan]{drake_plan()}} help file
for descriptions of the optional columns.)
Targets are the objects that drake generates,
and commands are the pieces of R code that produce them.
You can create and track custom files along the way
(see \code{\link[=file_in]{file_in()}}, \code{\link[=file_out]{file_out()}}, and \code{\link[=knitr_in]{knitr_in()}}).
Use the function \code{\link[=drake_plan]{drake_plan()}} to generate workflow plan
data frames.}

\item{targets}{Character vector, names of targets to build.
Dependencies are built too. Together, the \code{plan} and
\code{targets} comprise the workflow network
(i.e. the \code{graph} argument).
Changing either will change the network.}

\item{envir}{Environment to use. Defaults to the current
workspace, so you should not need to worry about this
most of the time. A deep copy of \code{envir} is made,
so you don't need to worry about your workspace being modified
by \code{make}. The deep copy inherits from the global environment.
Wherever necessary, objects and functions are imported
from \code{envir} and the global environment and
then reproducibly tracked as dependencies.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print target-by-target messages as \code{\link[=make]{make()}} progresses.
\item \code{2}: show a progress bar to track how many targets are
done so far.
}}

\item{hook}{Deprecated.}

\item{cache}{drake cache as created by \code{\link[=new_cache]{new_cache()}}.
See also \code{\link[=drake_cache]{drake_cache()}}.}

\item{fetch_cache}{Deprecated.}

\item{parallelism}{Character scalar, type of parallelism to use.
For detailed explanations, see the
\href{https://books.ropensci.org/drake/hpc.html}{high-performance computing chapter} # nolint
of the user manual.

You could also supply your own scheduler function
if you want to experiment or aggressively optimize.
The function should take a single \code{config} argument
(produced by \code{\link[=drake_config]{drake_config()}}). Existing examples
from \code{drake}'s internals are the \verb{backend_*()} functions:
\itemize{
\item \code{backend_loop()}
\item \code{backend_clustermq()}
\item \code{backend_future()}
However, this functionality is really a back door
and should not be used for production purposes unless you really
know what you are doing and you are willing to suffer setbacks
whenever \code{drake}'s unexported core functions are updated.
}}

\item{jobs}{Maximum number of parallel workers for processing the targets.
You can experiment with \code{\link[=predict_runtime]{predict_runtime()}}
to help decide on an appropriate number of jobs.
For details, visit
\url{https://books.ropensci.org/drake/time.html}.}

\item{jobs_preprocess}{Number of parallel jobs for processing the imports
and doing other preprocessing tasks.}

\item{packages}{Character vector packages to load, in the order
they should be loaded. Defaults to \code{rev(.packages())}, so you
should not usually need to set this manually. Just call
\code{\link[=library]{library()}} to load your packages before \code{make()}.
However, sometimes packages need to be strictly forced to load
in a certain order, especially if \code{parallelism} is
\code{"Makefile"}. To do this, do not use \code{\link[=library]{library()}}
or \code{\link[=require]{require()}} or \code{\link[=loadNamespace]{loadNamespace()}} or
\code{\link[=attachNamespace]{attachNamespace()}} to load any libraries beforehand.
Just list your packages in the \code{packages} argument in the order
you want them to be loaded.}

\item{lib_loc}{Character vector, optional.
Same as in \code{library()} or \code{require()}.
Applies to the \code{packages} argument (see above).}

\item{prework}{Expression (language object), list of expressions,
or character vector.
Code to run right before targets build.
Called only once if \code{parallelism} is \code{"loop"}
and once per target otherwise.
This code can be used to set global options, etc.}

\item{prepend}{Deprecated.}

\item{command}{Deprecated.}

\item{args}{Deprecated.}

\item{recipe_command}{Deprecated.}

\item{timeout}{\code{deprecated}. Use \code{elapsed} and \code{cpu} instead.}

\item{cpu}{Same as the \code{cpu} argument of \code{setTimeLimit()}.
Seconds of cpu time before a target times out.
Assign target-level cpu timeout times with an optional \code{cpu}
column in \code{plan}.}

\item{elapsed}{Same as the \code{elapsed} argument of \code{setTimeLimit()}.
Seconds of elapsed time before a target times out.
Assign target-level elapsed timeout times with an optional \code{elapsed}
column in \code{plan}.}

\item{retries}{Number of retries to execute if the target fails.
Assign target-level retries with an optional \code{retries}
column in \code{plan}.}

\item{force}{Logical. If \code{FALSE} (default) then \code{drake}
imposes checks if the cache was created with an old
and incompatible version of drake.
If there is an incompatibility, \code{make()} stops to
give you an opportunity to
downgrade \code{drake} to a compatible version
rather than rerun all your targets from scratch.}

\item{log_progress}{Logical, whether to log the progress
of individual targets as they are being built. Progress logging
creates extra files in the cache (usually the \verb{.drake/} folder)
and slows down \code{make()} a little.
If you need to reduce or limit the number of files in the cache,
call \code{make(log_progress = FALSE, recover = FALSE)}.}

\item{graph}{Deprecated.}

\item{trigger}{Name of the trigger to apply to all targets.
Ignored if \code{plan} has a \code{trigger} column.
See \code{\link[=trigger]{trigger()}} for details.}

\item{skip_targets}{Logical, whether to skip building the targets
in \code{plan} and just import objects and files.}

\item{skip_imports}{Logical, whether to totally neglect to
process the imports and jump straight to the targets. This can be useful
if your imports are massive and you just want to test your project,
but it is bad practice for reproducible data analysis.
This argument is overridden if you supply your own \code{graph} argument.}

\item{skip_safety_checks}{Logical, whether to skip the safety checks
on your workflow. Use at your own peril.}

\item{lazy_load}{An old feature, currently being questioned.
For the current recommendations on memory management, see
\url{https://books.ropensci.org/drake/memory.html#memory-strategies}.
The \code{lazy_load} argument is either a character vector or a logical.
For dynamic targets, the behavior is always \code{"eager"} (see below).
So the \code{lazy_load} argument is for static targets only.
Choices for \code{lazy_load}:
\itemize{
\item \code{"eager"}: no lazy loading. The target is loaded right away
with \code{\link[=assign]{assign()}}.
\item \code{"promise"}: lazy loading with \code{\link[=delayedAssign]{delayedAssign()}}
\item \code{"bind"}: lazy loading with active bindings:
\code{bindr::populate_env()}.
\item \code{TRUE}: same as \code{"promise"}.
\item \code{FALSE}: same as \code{"eager"}.
}

If \code{lazy_load} is \code{"eager"},
drake prunes the execution environment before each target/stage,
removing all superfluous targets
and then loading any dependencies it will need for building.
In other words, drake prepares the environment in advance
and tries to be memory efficient.
If \code{lazy_load} is \code{"bind"} or \code{"promise"}, drake assigns
promises to load any dependencies at the last minute.
Lazy loading may be more memory efficient in some use cases, but
it may duplicate the loading of dependencies, costing time.}

\item{session_info}{Logical, whether to save the \code{sessionInfo()}
to the cache. Defaults to \code{TRUE}.
This behavior is recommended for serious \code{\link[=make]{make()}}s
for the sake of reproducibility. This argument only exists to
speed up tests. Apparently, \code{sessionInfo()} is a bottleneck
for small \code{\link[=make]{make()}}s.}

\item{cache_log_file}{Name of the CSV cache log file to write.
If \code{TRUE}, the default file name is used (\code{drake_cache.CSV}).
If \code{NULL}, no file is written.
If activated, this option writes a flat text file
to represent the state of the cache
(fingerprints of all the targets and imports).
If you put the log file under version control, your commit history
will give you an easy representation of how your results change
over time as the rest of your project changes. Hopefully,
this is a step in the right direction for data reproducibility.}

\item{seed}{Integer, the root pseudo-random number generator
seed to use for your project.
In \code{\link[=make]{make()}}, \code{drake} generates a unique
local seed for each target using the global seed
and the target name. That way, different pseudo-random numbers
are generated for different targets, and this pseudo-randomness
is reproducible.

To ensure reproducibility across different R sessions,
\code{set.seed()} and \code{.Random.seed} are ignored and have no affect on
\code{drake} workflows. Conversely, \code{make()} does not usually
change \code{.Random.seed},
even when pseudo-random numbers are generated.
The exception to this last point is
\code{make(parallelism = "clustermq")}
because the \code{clustermq} package needs to generate random numbers
to set up ports and sockets for ZeroMQ.

On the first call to \code{make()} or \code{drake_config()}, \code{drake}
uses the random number generator seed from the \code{seed} argument.
Here, if the \code{seed} is \code{NULL} (default), \code{drake} uses a \code{seed} of \code{0}.
On subsequent \code{make()}s for existing projects, the project's
cached seed will be used in order to ensure reproducibility.
Thus, the \code{seed} argument must either be \code{NULL} or the same
seed from the project's cache (usually the \verb{.drake/} folder).
To reset the random number generator seed for a project,
use \code{clean(destroy = TRUE)}.}

\item{caching}{Character string, either \code{"master"} or \code{"worker"}.
\itemize{
\item \code{"master"}: Targets are built by remote workers and sent back to
the master process. Then, the master process saves them to the
cache (\code{config$cache}, usually a file system \code{storr}).
Appropriate if remote workers do not have access to the file system
of the calling R session. Targets are cached one at a time,
which may be slow in some situations.
\item \code{"worker"}: Remote workers not only build the targets, but also
save them to the cache. Here, caching happens in parallel.
However, remote workers need to have access to the file system
of the calling R session. Transferring target data across
a network can be slow.
}}

\item{keep_going}{Logical, whether to still keep running \code{\link[=make]{make()}}
if targets fail.}

\item{session}{Deprecated. Has no effect now.}

\item{pruning_strategy}{Deprecated. See \code{memory_strategy}.}

\item{makefile_path}{Deprecated.}

\item{console_log_file}{Deprecated in favor of \code{log_make}.}

\item{ensure_workers}{Deprecated.}

\item{garbage_collection}{Logical, whether to call \code{gc()} each time
a target is built during \code{\link[=make]{make()}}.}

\item{template}{A named list of values to fill in the \code{{{ ... }}}
placeholders in template files (e.g. from \code{\link[=drake_hpc_template_file]{drake_hpc_template_file()}}).
Same as the \code{template} argument of \code{clustermq::Q()} and
\code{clustermq::workers}.
Enabled for \code{clustermq} only (\code{make(parallelism = "clustermq")}),
not \code{future} or \code{batchtools} so far.
For more information, see the \code{clustermq} package:
\url{https://github.com/mschubert/clustermq}.
Some template placeholders such as \code{{{ job_name }}} and \code{{{ n_jobs }}}
cannot be set this way.}

\item{sleep}{Optional function on a single numeric argument \code{i}.
Default: \code{function(i) 0.01}.

To conserve memory, \code{drake} assigns a brand new closure to
\code{sleep}, so your custom function should not depend on in-memory data
except from loaded packages.

For parallel processing, \code{drake} uses
a central master process to check what the parallel
workers are doing, and for the affected high-performance
computing workflows, wait for data to arrive over a network.
In between loop iterations, the master process sleeps to avoid throttling.
The \code{sleep} argument to \code{make()} and \code{drake_config()}
allows you to customize how much time the master process spends
sleeping.

The \code{sleep} argument is a function that takes an argument
\code{i} and returns a numeric scalar, the number of seconds to
supply to \code{Sys.sleep()} after iteration \code{i} of checking.
(Here, \code{i} starts at 1.)
If the checking loop does something other than sleeping
on iteration \code{i}, then \code{i} is reset back to 1.

To sleep for the same amount of time between checks,
you might supply something like \code{function(i) 0.01}.
But to avoid consuming too many resources during heavier
and longer workflows, you might use an exponential
back-off: say,
\code{function(i) { 0.1 + 120 * pexp(i - 1, rate = 0.01) }}.}

\item{hasty_build}{A user-defined function.
In "hasty mode" (\code{make(parallelism = "hasty")})
this is the function that evaluates a target's command
and returns the resulting value. The \code{hasty_build} argument
has no effect if \code{parallelism} is any value other than "hasty".

The function you pass to \code{hasty_build} must have arguments \code{target}
and \code{config}. Here, \code{target} is a character scalar naming the
target being built, and \code{config} is a configuration list of
runtime parameters generated by \code{\link[=drake_config]{drake_config()}}.}

\item{memory_strategy}{Character scalar, name of the
strategy \code{drake} uses to load/unload a target's dependencies in memory.
You can give each target its own memory strategy,
(e.g. \code{drake_plan(x = 1, y = target(f(x), memory_strategy = "lookahead"))})
to override the global memory strategy. Choices:
\itemize{
\item \code{"speed"}: Once a target is newly built or loaded in memory,
just keep it there.
This choice maximizes speed and hogs memory.
\item \code{"autoclean"}: Just before building each new target,
unload everything from memory except the target's direct dependencies.
After a target is built, discard it from memory.
(Set \code{garbage_collection = TRUE} to make sure it is really gone.)
This option conserves memory, but it sacrifices speed because
each new target needs to reload
any previously unloaded targets from storage.
\item \code{"preclean"}: Just before building each new target,
unload everything from memory except the target's direct dependencies.
After a target is built, keep it in memory until \code{drake} determines
they can be unloaded.
This option conserves memory, but it sacrifices speed because
each new target needs to reload
any previously unloaded targets from storage.
\item \code{"lookahead"}: Just before building each new target,
search the dependency graph to find targets that will not be
needed for the rest of the current \code{make()} session.
After a target is built, keep it in memory until the next
memory management stage.
In this mode, targets are only in memory if they need to be loaded,
and we avoid superfluous reads from the cache.
However, searching the graph takes time,
and it could even double the computational overhead for large projects.
\item \code{"unload"}: Just before building each new target,
unload all targets from memory.
After a target is built, \strong{do not} keep it in memory.
This mode aggressively optimizes for both memory and speed,
but in commands and triggers,
you have to manually load any dependencies you need using \code{readd()}.
\item \code{"none"}: Do not manage memory at all.
Do not load or unload anything before building targets.
After a target is built, \strong{do not} keep it in memory.
This mode aggressively optimizes for both memory and speed,
but in commands and triggers,
you have to manually load any dependencies you need using \code{readd()}.
}

For even more direct
control over which targets \code{drake} keeps in memory, see the
help file examples of \code{\link[=drake_envir]{drake_envir()}}.
Also see the \code{garbage_collection} argument of \code{make()} and
\code{drake_config()}.}

\item{spec}{Deprecated.}

\item{layout}{Deprecated.}

\item{lock_envir}{Logical, whether to lock \code{config$envir} during \code{make()}.
If \code{TRUE}, \code{make()} quits in error whenever a command in your
\code{drake} plan (or \code{prework}) tries to add, remove, or modify
non-hidden variables in your environment/workspace/R session.
This is extremely important for ensuring the purity of your functions
and the reproducibility/credibility/trust you can place in your project.
\code{lock_envir} will be set to a default of \code{TRUE} in \code{drake} version
7.0.0 and higher.}

\item{history}{Logical, whether to record the build history
of your targets. You can also supply a
\href{https://github.com/wlandau/txtq}{\code{txtq}}, which is
how \code{drake} records history.
Must be \code{TRUE} for \code{\link[=drake_history]{drake_history()}} to work later.}

\item{recover}{Logical, whether to activate automated data recovery.
The default is \code{FALSE} because
\enumerate{
\item Automated data recovery is still experimental.
\item It has reproducibility issues.
Targets recovered from the distant past may have been generated
with earlier versions of R and earlier package environments
that no longer exist.
\item It is not always possible, especially when dynamic files
are combined with dynamic branching
(e.g. \code{dynamic = map(stuff)} and \code{format = "file"} etc.)
since behavior is harder to predict in advance.
}

How it works: if \code{recover} is \code{TRUE},
\code{drake} tries to salvage old target values from the cache
instead of running commands from the plan.
A target is recoverable if
\enumerate{
\item There is an old value somewhere in the cache that
shares the command, dependencies, etc.
of the target about to be built.
\item The old value was generated with \code{make(recoverable = TRUE)}.
}

If both conditions are met, \code{drake} will
\enumerate{
\item Assign the most recently-generated admissible data to the target, and
\item skip the target's command.
}

Functions \code{\link[=recoverable]{recoverable()}} and \code{\link[=r_recoverable]{r_recoverable()}} show the most upstream
outdated targets that will be recovered in this way in the next
\code{\link[=make]{make()}} or \code{\link[=r_make]{r_make()}}.}

\item{recoverable}{Logical, whether to make target values recoverable
with \code{make(recover = TRUE)}.
This requires writing extra files to the cache,
and it prevents old metadata from being removed with garbage collection
(\code{clean(garbage_collection = TRUE)}, \code{gc()} in \code{storr}s).
If you need to limit the cache size or the number of files in the cache,
consider \code{make(recoverable = FALSE, progress = FALSE)}.
Recovery is not always possible, especially when dynamic files
are combined with dynamic branching
(e.g. \code{dynamic = map(stuff)} and \code{format = "file"} etc.)
since behavior is harder to predict in advance.}

\item{curl_handles}{A named list of curl handles. Each value is an
object from \code{curl::new_handle()}, and each name is a URL
(and should start with "http", "https", or "ftp").
Example:
list(
\verb{http://httpbin.org/basic-auth} = curl::new_handle(
username = "user", password = "passwd"
)
)
Then, if your plan has
\code{file_in("http://httpbin.org/basic-auth/user/passwd")}
\code{drake} will authenticate using the username and password of the handle
for \verb{http://httpbin.org/basic-auth/}.

\code{drake} uses partial matching on text to
find the right handle of the \code{file_in()} URL, so the name of the handle
could be the complete URL (\code{"http://httpbin.org/basic-auth/user/passwd"})
or a part of the URL (e.g. \code{"http://httpbin.org/"} or
\code{"http://httpbin.org/basic-auth/"}). If you have multiple handles
whose names match your URL, \code{drake} will choose the closest match.}

\item{max_expand}{Positive integer, optional.
\code{max_expand} is the maximum number of targets to generate in each
\code{map()}, \code{cross()}, or \code{group()} dynamic transform.
Useful if you have a massive number of dynamic sub-targets and you want to
work with only the first few sub-targets before scaling up.
Note: the \code{max_expand} argument of \code{make()} and
\code{drake_config()} is for dynamic branching only.
The static branching \code{max_expand}
is an argument of \code{drake_plan()} and \code{transform_plan()}.}

\item{log_build_times}{Logical, whether to record build_times for targets.
Mac users may notice a 20\% speedup in \code{make()}
with \code{build_times = FALSE}.}

\item{format}{Character, an optional custom storage format for targets
without an explicit \code{target(format = ...)} in the plan. Details
about formats:
\url{https://books.ropensci.org/drake/plans.html#special-data-formats-for-targets} # nolint}

\item{lock_cache}{Logical, whether to lock the cache before running \code{make()}
etc. It is usually recommended to keep cache locking on.
However, if you interrupt \code{make()} before it can clean itself up,
then the cache will stay locked,
and you will need to manually unlock it with
\code{drake::drake_cache("xyz")$unlock()}. Repeatedly unlocking the cache
by hand is annoying, and \code{lock_cache = FALSE} prevents the cache
from locking in the first place.}

\item{log_make}{Optional character scalar of a file name or
connection object (such as \code{stdout()}) to dump maximally verbose
log information for \code{\link[=make]{make()}} and other functions (all functions that
accept a \code{config} argument, plus \code{drake_config()}).
If you choose to use a text file as the console log,
it will persist over multiple function calls
until you delete it manually.
Fields in each row the log file, from left to right:
- The node name (short host name) of the
computer (from \code{Sys.info()["nodename"]}).
- The process ID (from \code{Sys.getpid()}).
- A timestamp with the date and time (in microseconds).
- A brief description of what \code{drake} was doing.\verb{ The fields are separated by pipe symbols (}"|"`).}
}
\value{
A configured \code{drake} workflow.
}
\description{
Call this function inside the \verb{_drake.R}
script for \code{\link[=r_make]{r_make()}} and friends.
All non-deprecated function arguments are the same
between \code{\link[=make]{make()}} and \code{\link[=drake_config]{drake_config()}}.
}
\details{
In \code{drake}, \code{\link[=make]{make()}} has two stages:
\enumerate{
\item Configure a workflow to your environment and plan.
\item Build targets.
The \code{\link[=drake_config]{drake_config()}} function just does step (1),
which is a common requirement for not only \code{\link[=make]{make()}},
but also utility functions like \code{\link[=vis_drake_graph]{vis_drake_graph()}}
and \code{\link[=outdated]{outdated()}}. That is why \code{\link[=drake_config]{drake_config()}}
is a requirement for the \verb{_drake.R} script, which
powers \code{\link[=r_make]{r_make()}}, \code{\link[=r_outdated]{r_outdated()}}, \code{\link[=r_vis_drake_graph]{r_vis_drake_graph()}}, etc.
}
}
\section{Recovery}{

\code{make(recover = TRUE, recoverable = TRUE)}
powers automated data recovery.
The default of \code{recover} is \code{FALSE} because
\enumerate{
\item Automated data recovery is still experimental.
\item It has reproducibility issues.
Targets recovered from the distant past may have been generated
with earlier versions of R and earlier package environments
that no longer exist.
}

How it works: if \code{recover} is \code{TRUE},
\code{drake} tries to salvage old target values from the cache
instead of running commands from the plan.
A target is recoverable if
\enumerate{
\item There is an old value somewhere in the cache that
shares the command, dependencies, etc.
of the target about to be built.
\item The old value was generated with \code{make(recoverable = TRUE)}.
}

If both conditions are met, \code{drake} will
\enumerate{
\item Assign the most recently-generated admissible data to the target, and
\item skip the target's command.
}
}

\examples{
\dontrun{
isolate_example("quarantine side effects", {
if (requireNamespace("knitr", quietly = TRUE)) {
writeLines(
  c(
    "library(drake)",
    "load_mtcars_example()",
    "drake_config(my_plan, targets = c(\"small\", \"large\"))"
  ),
  "_drake.R" # default value of the `source` argument
)
cat(readLines("_drake.R"), sep = "\n")
r_outdated()
r_make()
r_outdated()
}
})
}
}
\seealso{
\code{\link[=make]{make()}}, \code{\link[=drake_plan]{drake_plan()}}, \code{\link[=vis_drake_graph]{vis_drake_graph()}}
}
