% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_times.R
\name{build_times}
\alias{build_times}
\title{See the time it took to build each target.
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}}
\usage{
build_times(
  ...,
  path = NULL,
  search = NULL,
  digits = 3,
  cache = drake::drake_cache(path = path),
  targets_only = NULL,
  verbose = NULL,
  jobs = 1,
  type = c("build", "command"),
  list = character(0)
)
}
\arguments{
\item{...}{Targets to load from the cache: as names (symbols) or
character strings. If the \code{tidyselect} package is installed,
you can also supply \code{dplyr}-style \code{tidyselect}
commands such as \code{starts_with()}, \code{ends_with()}, and \code{one_of()}.}

\item{path}{Path to a \code{drake} cache
(usually a hidden \verb{.drake/} folder) or \code{NULL}.}

\item{search}{Deprecated.}

\item{digits}{How many digits to round the times to.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} is ignored.}

\item{targets_only}{Deprecated.}

\item{verbose}{Deprecated on 2019-09-11.}

\item{jobs}{Number of jobs/workers for parallel processing.}

\item{type}{Type of time you want: either \code{"build"}
for the full build time including the time it took to
store the target, or \code{"command"} for the time it took
just to run the command.}

\item{list}{Character vector of targets to select.}
}
\value{
A data frame of times, each from \code{\link[=system.time]{system.time()}}.
}
\description{
Applies to targets in your plan, not imports or files.
}
\details{
Times for dynamic targets
(\verb{https://books.ropensci.org/drake/dynamic.html})
only reflect the time it takes
to post-process the sub-targets (typically very fast)
and exclude the time it takes to build the sub-targets themselves.
Sub-targets build times are listed individually.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
if (requireNamespace("lubridate")) {
# Show the build times for the mtcars example.
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Build all the targets.
print(build_times()) # Show how long it took to build each target.
}
}
})
}
}
\seealso{
\code{\link[=predict_runtime]{predict_runtime()}}
}
