% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-deprecate.R
\name{get_cache}
\alias{get_cache}
\title{Deprecated: the default cache of a \code{drake} project.}
\usage{
get_cache(path = getwd(), search = TRUE, verbose = 1L,
  force = FALSE, fetch_cache = NULL, console_log_file = NULL)
}
\arguments{
\item{path}{Character, either the root file path of a \code{drake} project
or a folder containing the root (top-level working directory
where you plan to call \code{\link[=make]{make()}}).
If this is too confusing, feel free to just use \code{storr::storr_rds()}
to get the cache.
If \code{search = FALSE}, \code{path} must be the root.
If \code{search = TRUE}, you can specify any
subdirectory of the project. Let's say \code{"/home/you/my_project"}
is the root. The following are equivalent and correct:
\itemize{
\item \code{get_cache(path = "/home/you/my_project", search = FALSE)}
\item \code{get_cache(path = "/home/you/my_project", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/subdir/x", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/.drake", search = TRUE)}
\item \code{get_cache(path = "/home/you/my_project/.drake/keys", search = TRUE)}
}}

\item{search}{Deprecated.}

\item{verbose}{Integer, control printing to the console/terminal.
\itemize{
\item \code{0}: print nothing.
\item \code{1}: print targets, retries, and failures.
\item \code{2}: also show a spinner when preprocessing tasks are underway.
}}

\item{force}{Deprecated.}

\item{fetch_cache}{Deprecated.}

\item{console_log_file}{Optional character scalar of a file name or
connection object (such as \code{stdout()}) to dump maximally verbose
log information for \code{\link[=make]{make()}} and other functions (all functions that
accept a \code{config} argument, plus \code{drake_config()}).
If you choose to use a text file as the console log,
it will persist over multiple function calls
until you delete it manually.
Fields in each row the log file, from left to right:
- The node name (short host name) of the
computer (from \code{Sys.info()["nodename"]}).
- The process ID (from \code{Sys.getpid()}).
- A timestamp with the date and time (in microseconds).
- A brief description of what \code{drake} was doing.\code{ The fields are separated by pipe symbols (}"|"`).}
}
\description{
Use \code{\link[=drake_cache]{drake_cache()}} instead.
}
\details{
Deprecated on 2019-05-25.
}
\examples{
\dontrun{
isolate_example("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
clean(destroy = TRUE)
# No cache is available.
get_cache() # NULL
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
x <- get_cache() # Now, there is a cache.
y <- storr::storr_rds(".drake") # Equivalent.
# List the objects readable from the cache with readd().
x$list()
}
})
}
}
\keyword{internal}
