% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drake_plan_helpers.R
\name{bind_plans}
\alias{bind_plans}
\title{Row-bind together drake plans
\lifecycle{stable}}
\usage{
bind_plans(...)
}
\arguments{
\item{...}{Workflow plan data frames (see \code{\link[=drake_plan]{drake_plan()}}).}
}
\description{
Combine drake plans together in a way that
correctly fills in missing entries.
}
\examples{
# You might need to refresh your data regularly (see ?triggers).
download_plan <- drake_plan(
  data = target(
    command = download_data(),
    trigger = "always"
  )
)
# But if the data don't change, the analyses don't need to change.
analysis_plan <- drake_plan(
  usage = get_usage_metrics(data),
  topline = scrape_topline_table(data)
)
your_plan <- bind_plans(download_plan, analysis_plan)
your_plan
}
\seealso{
\code{\link[=drake_plan]{drake_plan()}}, \code{\link[=make]{make()}}
}
